/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.dbclient.AutoClosingDoubleStream;
import io.helidon.dbclient.AutoClosingHandler;
import io.helidon.dbclient.AutoClosingIntStream;
import io.helidon.dbclient.AutoClosingStream;
import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

class AutoClosingLongStream
implements LongStream {
    private final LongStream delegate;
    private final Runnable closeHandler;

    private AutoClosingLongStream(LongStream delegate, Runnable closeHandler) {
        this.delegate = delegate;
        this.closeHandler = closeHandler;
    }

    static LongStream decorate(LongStream stream, Runnable closeHandler) {
        if (stream instanceof AutoClosingLongStream) {
            return stream;
        }
        return new AutoClosingLongStream(stream, AutoClosingHandler.decorate(closeHandler));
    }

    @Override
    public void forEach(LongConsumer action) {
        try {
            this.delegate.forEach(action);
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        try {
            this.delegate.forEachOrdered(action);
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public long[] toArray() {
        try {
            long[] lArray = this.delegate.toArray();
            return lArray;
        }
        finally {
            this.closeHandler.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        try {
            long l = this.delegate.reduce(identity, op);
            return l;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        try {
            OptionalLong optionalLong = this.delegate.reduce(op);
            return optionalLong;
        }
        finally {
            this.closeHandler.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        try {
            R r = this.delegate.collect(supplier, accumulator, combiner);
            return r;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public long sum() {
        try {
            long l = this.delegate.sum();
            return l;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalLong min() {
        try {
            OptionalLong optionalLong = this.delegate.min();
            return optionalLong;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalLong max() {
        try {
            OptionalLong optionalLong = this.delegate.max();
            return optionalLong;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public long count() {
        try {
            long l = this.delegate.count();
            return l;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalDouble average() {
        try {
            OptionalDouble optionalDouble = this.delegate.average();
            return optionalDouble;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        try {
            LongSummaryStatistics longSummaryStatistics = this.delegate.summaryStatistics();
            return longSummaryStatistics;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        try {
            boolean bl = this.delegate.anyMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        try {
            boolean bl = this.delegate.allMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        try {
            boolean bl = this.delegate.noneMatch(predicate);
            return bl;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalLong findFirst() {
        try {
            OptionalLong optionalLong = this.delegate.findFirst();
            return optionalLong;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public OptionalLong findAny() {
        try {
            OptionalLong optionalLong = this.delegate.findAny();
            return optionalLong;
        }
        finally {
            this.closeHandler.run();
        }
    }

    @Override
    public LongStream filter(LongPredicate predicate) {
        return AutoClosingLongStream.decorate(this.delegate.filter(predicate), this.closeHandler);
    }

    @Override
    public LongStream map(LongUnaryOperator mapper) {
        return AutoClosingLongStream.decorate(this.delegate.map(mapper), this.closeHandler);
    }

    @Override
    public <U> Stream<U> mapToObj(LongFunction<? extends U> mapper) {
        return AutoClosingStream.decorate(this.delegate.mapToObj(mapper), this.closeHandler);
    }

    @Override
    public IntStream mapToInt(LongToIntFunction mapper) {
        return AutoClosingIntStream.decorate(this.delegate.mapToInt(mapper), this.closeHandler);
    }

    @Override
    public DoubleStream mapToDouble(LongToDoubleFunction mapper) {
        return AutoClosingDoubleStream.decorate(this.delegate.mapToDouble(mapper), this.closeHandler);
    }

    @Override
    public LongStream flatMap(LongFunction<? extends LongStream> mapper) {
        return AutoClosingLongStream.decorate(this.delegate.flatMap(mapper), this.closeHandler);
    }

    @Override
    public LongStream mapMulti(LongStream.LongMapMultiConsumer mapper) {
        return AutoClosingLongStream.decorate(this.delegate.mapMulti(mapper), this.closeHandler);
    }

    @Override
    public LongStream distinct() {
        return AutoClosingLongStream.decorate(this.delegate.distinct(), this.closeHandler);
    }

    @Override
    public LongStream sorted() {
        return AutoClosingLongStream.decorate(this.delegate.sorted(), this.closeHandler);
    }

    @Override
    public LongStream peek(LongConsumer action) {
        return AutoClosingLongStream.decorate(this.delegate.peek(action), this.closeHandler);
    }

    @Override
    public LongStream limit(long maxSize) {
        return AutoClosingLongStream.decorate(this.delegate.limit(maxSize), this.closeHandler);
    }

    @Override
    public LongStream skip(long n) {
        return AutoClosingLongStream.decorate(this.delegate.skip(n), this.closeHandler);
    }

    @Override
    public LongStream takeWhile(LongPredicate predicate) {
        return AutoClosingLongStream.decorate(this.delegate.takeWhile(predicate), this.closeHandler);
    }

    @Override
    public LongStream dropWhile(LongPredicate predicate) {
        return AutoClosingLongStream.decorate(this.delegate.dropWhile(predicate), this.closeHandler);
    }

    @Override
    public DoubleStream asDoubleStream() {
        return AutoClosingDoubleStream.decorate(this.delegate.asDoubleStream(), this.closeHandler);
    }

    @Override
    public Stream<Long> boxed() {
        return AutoClosingStream.decorate(this.delegate.boxed());
    }

    @Override
    public LongStream sequential() {
        return AutoClosingLongStream.decorate(this.delegate.sequential(), this.closeHandler);
    }

    @Override
    public LongStream parallel() {
        return AutoClosingLongStream.decorate(this.delegate.parallel(), this.closeHandler);
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        final PrimitiveIterator.OfLong iterator = this.delegate.iterator();
        return new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                if (iterator.hasNext()) {
                    return true;
                }
                AutoClosingLongStream.this.closeHandler.run();
                return false;
            }

            @Override
            public long nextLong() {
                return iterator.nextLong();
            }
        };
    }

    @Override
    public Spliterator.OfLong spliterator() {
        final Spliterator.OfLong spliterator = this.delegate.spliterator();
        return new Spliterator.OfLong(){

            @Override
            public boolean tryAdvance(LongConsumer action) {
                if (spliterator.tryAdvance(action)) {
                    return true;
                }
                AutoClosingLongStream.this.closeHandler.run();
                return false;
            }

            @Override
            public Spliterator.OfLong trySplit() {
                return spliterator.trySplit();
            }

            @Override
            public long estimateSize() {
                return spliterator.estimateSize();
            }

            @Override
            public int characteristics() {
                return spliterator.characteristics();
            }
        };
    }

    @Override
    public boolean isParallel() {
        return this.delegate.isParallel();
    }

    @Override
    public LongStream unordered() {
        return AutoClosingLongStream.decorate((LongStream)this.delegate.unordered(), this.closeHandler);
    }

    @Override
    public LongStream onClose(Runnable closeHandler) {
        return AutoClosingLongStream.decorate((LongStream)this.delegate.onClose(closeHandler), this.closeHandler);
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

