/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import java.util.Optional;
import java.util.stream.Stream;

public interface DbExecute {
    public DbStatementQuery createNamedQuery(String var1, String var2);

    public DbStatementQuery createNamedQuery(String var1);

    public DbStatementQuery createQuery(String var1);

    default public Stream<DbRow> namedQuery(String statementName, Object ... parameters) {
        return ((DbStatementQuery)this.createNamedQuery(statementName).params(parameters)).execute();
    }

    default public Stream<DbRow> query(String statement, Object ... parameters) {
        return ((DbStatementQuery)this.createQuery(statement).params(parameters)).execute();
    }

    public DbStatementGet createNamedGet(String var1, String var2);

    public DbStatementGet createNamedGet(String var1);

    public DbStatementGet createGet(String var1);

    default public Optional<DbRow> namedGet(String statementName, Object ... parameters) {
        return ((DbStatementGet)this.createNamedGet(statementName).params(parameters)).execute();
    }

    default public Optional<DbRow> get(String statement, Object ... parameters) {
        return ((DbStatementGet)this.createGet(statement).params(parameters)).execute();
    }

    default public DbStatementDml createNamedInsert(String statementName, String statement) {
        return this.createNamedDmlStatement(statementName, statement);
    }

    public DbStatementDml createNamedInsert(String var1);

    public DbStatementDml createInsert(String var1);

    default public long namedInsert(String statementName, Object ... parameters) {
        return ((DbStatementDml)this.createNamedInsert(statementName).params(parameters)).execute();
    }

    default public long insert(String statement, Object ... parameters) {
        return ((DbStatementDml)this.createInsert(statement).params(parameters)).execute();
    }

    default public DbStatementDml createNamedUpdate(String statementName, String statement) {
        return this.createNamedDmlStatement(statementName, statement);
    }

    public DbStatementDml createNamedUpdate(String var1);

    public DbStatementDml createUpdate(String var1);

    default public long namedUpdate(String statementName, Object ... parameters) {
        return ((DbStatementDml)this.createNamedUpdate(statementName).params(parameters)).execute();
    }

    default public long update(String statement, Object ... parameters) {
        return ((DbStatementDml)this.createUpdate(statement).params(parameters)).execute();
    }

    default public DbStatementDml createNamedDelete(String statementName, String statement) {
        return this.createNamedDmlStatement(statementName, statement);
    }

    public DbStatementDml createNamedDelete(String var1);

    public DbStatementDml createDelete(String var1);

    default public long namedDelete(String statementName, Object ... parameters) {
        return ((DbStatementDml)this.createNamedDelete(statementName).params(parameters)).execute();
    }

    default public long delete(String statement, Object ... parameters) {
        return ((DbStatementDml)this.createDelete(statement).params(parameters)).execute();
    }

    public DbStatementDml createNamedDmlStatement(String var1, String var2);

    public DbStatementDml createNamedDmlStatement(String var1);

    public DbStatementDml createDmlStatement(String var1);

    default public long namedDml(String statementName, Object ... parameters) {
        return ((DbStatementDml)this.createNamedDmlStatement(statementName).params(parameters)).execute();
    }

    default public long dml(String statement, Object ... parameters) {
        return ((DbStatementDml)this.createDmlStatement(statement).params(parameters)).execute();
    }

    public <C> C unwrap(Class<C> var1);
}

