/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbClientContext;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.DbContext;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbStatements;
import java.util.List;

public class DbExecuteContext
implements DbContext {
    private final String statementName;
    private final String statement;
    private final DbClientContext clientContext;

    protected DbExecuteContext(BuilderBase<? extends BuilderBase<?, ? extends DbExecuteContext>, ? extends DbExecuteContext> builder) {
        this.statementName = builder.statementName;
        this.statement = builder.statement;
        this.clientContext = builder.clientContext;
    }

    public String statementName() {
        return this.statementName;
    }

    public String statement() {
        return this.statement;
    }

    @Override
    public boolean missingMapParametersAsNull() {
        return this.clientContext.missingMapParametersAsNull();
    }

    @Override
    public DbStatements statements() {
        return this.clientContext.statements();
    }

    @Override
    public DbMapperManager dbMapperManager() {
        return this.clientContext.dbMapperManager();
    }

    @Override
    public MapperManager mapperManager() {
        return this.clientContext.mapperManager();
    }

    @Override
    public List<DbClientService> clientServices() {
        return this.clientContext.clientServices();
    }

    @Override
    public String dbType() {
        return this.clientContext.dbType();
    }

    protected <C extends DbClientContext> C clientContext(Class<C> cls) {
        return (C)((DbClientContext)cls.cast(this.clientContext));
    }

    public static DbExecuteContext create(String statementName, String statement, DbClientContext context) {
        return ((Builder)((Builder)((Builder)DbExecuteContext.builder().statement(statement)).statementName(statementName)).clientContext(context)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static abstract class BuilderBase<B extends BuilderBase<B, T>, T extends DbExecuteContext>
    implements io.helidon.common.Builder<B, T> {
        private String statementName;
        private String statement;
        private DbClientContext clientContext;

        public B statement(String statement) {
            this.statement = statement;
            return (B)((BuilderBase)this.identity());
        }

        public B statementName(String statementName) {
            this.statementName = statementName;
            return (B)((BuilderBase)this.identity());
        }

        public B clientContext(DbClientContext clientContext) {
            this.clientContext = clientContext;
            return (B)((BuilderBase)this.identity());
        }
    }

    public static final class Builder
    extends BuilderBase<Builder, DbExecuteContext> {
        public DbExecuteContext build() {
            return new DbExecuteContext(this);
        }
    }
}

