/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.Value;
import io.helidon.dbclient.DbColumn;
import java.util.Optional;
import java.util.function.Function;

public abstract class DbColumnBase
implements DbColumn {
    private final Object value;
    private final MapperManager mapperManager;
    private final String[] mappingQualifiers;

    protected DbColumnBase(Object value, MapperManager mapperManager, String ... mappingQualifiers) {
        this.value = value;
        this.mapperManager = mapperManager;
        this.mappingQualifiers = mappingQualifiers;
    }

    protected Object rawValue() {
        return this.value;
    }

    @Override
    public <T> T get(Class<T> type) throws MapperException {
        if (null == this.value) {
            return null;
        }
        if (type.isAssignableFrom(this.value.getClass())) {
            return type.cast(this.value);
        }
        return this.map(this.value, type);
    }

    @Override
    public <T> T get(GenericType<T> type) throws MapperException {
        Class theClass;
        if (null == this.value) {
            return null;
        }
        if (type.isClass() && (theClass = type.rawType()).isAssignableFrom(this.value.getClass())) {
            return (T)type.cast(this.value);
        }
        return this.map(this.value, type);
    }

    public <N> Value<N> as(Class<N> type) throws MapperException {
        return Value.create((MapperManager)this.mapperManager, (String)this.name(), this.get(type), (String[])new String[]{"dbclient", "column"});
    }

    public <N> Value<N> as(GenericType<N> type) throws MapperException {
        return Value.create((MapperManager)this.mapperManager, (String)this.name(), this.get(type), (String[])new String[]{"dbclient", "column"});
    }

    public <N> Value<N> as(Function<? super Object, ? extends N> mapper) {
        return Value.create((MapperManager)this.mapperManager, (String)this.name(), mapper.apply(this.value), (String[])new String[]{"dbclient", "column"});
    }

    public Optional<Object> asOptional() throws MapperException {
        return Optional.of(this.value);
    }

    public Value<Boolean> asBoolean() {
        return this.as(Boolean.class);
    }

    public Value<String> asString() {
        return this.as(String.class);
    }

    public Value<Integer> asInt() {
        return this.as(Integer.class);
    }

    public Value<Long> asLong() {
        return this.as(Long.class);
    }

    public Value<Double> asDouble() {
        return this.as(Double.class);
    }

    protected <SRC, T> T map(SRC value, GenericType<T> type) {
        Class<?> theClass = value.getClass();
        return (T)this.mapperManager.map(value, GenericType.create(theClass), type, this.mappingQualifiers);
    }

    protected <SRC, T> T map(SRC value, Class<T> type) {
        Class<?> theClass = value.getClass();
        try {
            return (T)this.mapperManager.map(value, theClass, type, this.mappingQualifiers);
        }
        catch (MapperException e) {
            if (type.equals(String.class)) {
                return (T)String.valueOf(value);
            }
            throw e;
        }
    }
}

