/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.context.Context;
import io.helidon.dbclient.DbClientServiceContextImpl;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbStatementParameters;
import io.helidon.dbclient.DbStatementType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface DbClientServiceContext {
    public Context context();

    public String statement();

    public String statementName();

    public DbStatementType statementType();

    public DbStatementParameters statementParameters();

    public String dbType();

    public CompletionStage<Void> statementFuture();

    public CompletionStage<Long> resultFuture();

    public DbClientServiceContext statement(String var1, List<Object> var2);

    public DbClientServiceContext statement(String var1, Map<String, Object> var2);

    public DbClientServiceContext parameters(List<Object> var1);

    public DbClientServiceContext parameters(Map<String, Object> var1);

    public DbClientServiceContext context(Context var1);

    public DbClientServiceContext statement(String var1);

    public DbClientServiceContext statementName(String var1);

    public static DbClientServiceContext create(DbExecuteContext execContext, DbStatementType stmtType, CompletionStage<Void> stmtFuture, CompletionStage<Long> queryFuture, DbStatementParameters stmtParams) {
        return new DbClientServiceContextImpl(execContext, stmtType, stmtFuture, queryFuture, stmtParams);
    }
}

