/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import java.util.Optional;

public interface DbExecute {
    public DbStatementQuery createNamedQuery(String var1, String var2);

    public DbStatementQuery createNamedQuery(String var1);

    public DbStatementQuery createQuery(String var1);

    default public Multi<DbRow> namedQuery(String statementName, Object ... parameters) {
        return (Multi)((DbStatementQuery)this.createNamedQuery(statementName).params(parameters)).execute();
    }

    default public Multi<DbRow> query(String statement, Object ... parameters) {
        return (Multi)((DbStatementQuery)this.createQuery(statement).params(parameters)).execute();
    }

    public DbStatementGet createNamedGet(String var1, String var2);

    public DbStatementGet createNamedGet(String var1);

    public DbStatementGet createGet(String var1);

    default public Single<Optional<DbRow>> namedGet(String statementName, Object ... parameters) {
        return (Single)((DbStatementGet)this.createNamedGet(statementName).params(parameters)).execute();
    }

    default public Single<Optional<DbRow>> get(String statement, Object ... parameters) {
        return (Single)((DbStatementGet)this.createGet(statement).params(parameters)).execute();
    }

    default public DbStatementDml createNamedInsert(String statementName, String statement) {
        return this.createNamedDmlStatement(statementName, statement);
    }

    public DbStatementDml createNamedInsert(String var1);

    public DbStatementDml createInsert(String var1);

    default public Single<Long> namedInsert(String statementName, Object ... parameters) {
        return (Single)((DbStatementDml)this.createNamedInsert(statementName).params(parameters)).execute();
    }

    default public Single<Long> insert(String statement, Object ... parameters) {
        return (Single)((DbStatementDml)this.createInsert(statement).params(parameters)).execute();
    }

    default public DbStatementDml createNamedUpdate(String statementName, String statement) {
        return this.createNamedDmlStatement(statementName, statement);
    }

    public DbStatementDml createNamedUpdate(String var1);

    public DbStatementDml createUpdate(String var1);

    default public Single<Long> namedUpdate(String statementName, Object ... parameters) {
        return (Single)((DbStatementDml)this.createNamedUpdate(statementName).params(parameters)).execute();
    }

    default public Single<Long> update(String statement, Object ... parameters) {
        return (Single)((DbStatementDml)this.createUpdate(statement).params(parameters)).execute();
    }

    default public DbStatementDml createNamedDelete(String statementName, String statement) {
        return this.createNamedDmlStatement(statementName, statement);
    }

    public DbStatementDml createNamedDelete(String var1);

    public DbStatementDml createDelete(String var1);

    default public Single<Long> namedDelete(String statementName, Object ... parameters) {
        return (Single)((DbStatementDml)this.createNamedDelete(statementName).params(parameters)).execute();
    }

    default public Single<Long> delete(String statement, Object ... parameters) {
        return (Single)((DbStatementDml)this.createDelete(statement).params(parameters)).execute();
    }

    public DbStatementDml createNamedDmlStatement(String var1, String var2);

    public DbStatementDml createNamedDmlStatement(String var1);

    public DbStatementDml createDmlStatement(String var1);

    default public Single<Long> namedDml(String statementName, Object ... parameters) {
        return (Single)((DbStatementDml)this.createNamedDmlStatement(statementName).params(parameters)).execute();
    }

    default public Single<Long> dml(String statement, Object ... parameters) {
        return (Single)((DbStatementDml)this.createDmlStatement(statement).params(parameters)).execute();
    }

    public <C> Single<C> unwrap(Class<C> var1);
}

