/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.tracing;

import io.helidon.config.Config;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.spi.DbClientServiceProvider;
import io.helidon.dbclient.tracing.DbClientTracing;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class DbClientTracingProvider
implements DbClientServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(DbClientTracingProvider.class.getName());

    public String configKey() {
        return "tracing";
    }

    public Collection<DbClientService> create(Config config) {
        List tracingConfigs = (List)config.asNodeList().orElseGet(List::of);
        LinkedList<DbClientService> result = new LinkedList<DbClientService>();
        for (Config tracingConfig : tracingConfigs) {
            result.add(this.fromConfig(tracingConfig));
        }
        if (result.isEmpty()) {
            LOGGER.info("DB Client tracing is enabled, yet none is configured in config.");
        }
        return result;
    }

    private DbClientService fromConfig(Config config) {
        return DbClientTracing.create(config);
    }
}

