/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbContext;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbResultDml;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.mongodb.MongoDbRow;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.List;
import java.util.stream.Stream;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.conversions.Bson;

public class MongoDbStatementDml
extends MongoDbStatement<DbStatementDml>
implements DbStatementDml {
    private static final System.Logger LOGGER = System.getLogger(MongoDbStatementDml.class.getName());
    private boolean returnGeneratedKeys;
    private final DbStatementType type;
    private final DocumentCodec codec = new DocumentCodec();
    private final DecoderContext decoderContext = DecoderContext.builder().build();

    MongoDbStatementDml(MongoDatabase db, DbStatementType type, DbExecuteContext context) {
        super(db, context);
        this.type = type;
    }

    public DbStatementType statementType() {
        return this.type;
    }

    public long execute() {
        return (Long)this.doExecute((future, context) -> {
            MongoDbStatement.MongoStatement stmt = new MongoDbStatement.MongoStatement(this.type, this.prepareStatement((DbClientServiceContext)context));
            try {
                long result = switch (this.type) {
                    case DbStatementType.INSERT -> this.executeInsert(stmt);
                    case DbStatementType.UPDATE -> this.executeUpdate(stmt);
                    case DbStatementType.DELETE -> this.executeDelete(stmt);
                    case DbStatementType.DML -> this.executeDml(stmt);
                    default -> throw new UnsupportedOperationException(String.format("Statement operation not yet supported: %s", this.type.name()));
                };
                future.complete(result);
                LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("%s DML %s execution succeeded", this.type.name(), this.context().statementName()));
                return result;
            }
            catch (UnsupportedOperationException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("%s DML %s execution failed", this.type.name(), this.context().statementName()));
                throw throwable;
            }
        });
    }

    public DbResultDml insert() {
        return (DbResultDml)this.doExecute((future, context) -> {
            MongoDbStatement.MongoStatement stmt = new MongoDbStatement.MongoStatement(this.type, this.prepareStatement((DbClientServiceContext)context));
            try {
                DbResultDml result = switch (this.type) {
                    case DbStatementType.INSERT -> this.executeInsertAsDbResultDml(stmt);
                    case DbStatementType.UPDATE -> this.executeUpdateAsDbResultDml(stmt);
                    case DbStatementType.DELETE -> this.executeDeleteAsDbResultDml(stmt);
                    case DbStatementType.DML -> this.executeDmlAsDbResultDml(stmt);
                    default -> throw new UnsupportedOperationException(String.format("Statement operation not yet supported: %s", this.type.name()));
                };
                future.complete(result.result());
                LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("%s DML %s execution succeeded", this.type.name(), this.context().statementName()));
                return result;
            }
            catch (UnsupportedOperationException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("%s DML %s execution failed", this.type.name(), this.context().statementName()));
                throw throwable;
            }
        });
    }

    public DbStatementDml returnGeneratedKeys() {
        this.returnGeneratedKeys = true;
        return this;
    }

    public DbStatementDml returnColumns(List<String> columnNames) {
        throw new UnsupportedOperationException("Retrieval of specific auto-generated columns is not supported for Mongo");
    }

    private Long executeInsert(MongoDbStatement.MongoStatement stmt) {
        MongoCollection mc = this.db().getCollection(stmt.getCollection());
        mc.insertOne((Object)stmt.getValue());
        return 1L;
    }

    private DbResultDml executeInsertAsDbResultDml(MongoDbStatement.MongoStatement stmt) {
        BsonValue insertedId;
        MongoCollection mc = this.db().getCollection(stmt.getCollection());
        InsertOneResult result = mc.insertOne((Object)stmt.getValue());
        if (this.returnGeneratedKeys && result.wasAcknowledged() && (insertedId = result.getInsertedId()) != null) {
            return DbResultDml.create(Stream.of(new MongoDbRow(this.codec.decode((BsonReader)new BsonDocumentReader(new BsonDocument("_id", insertedId)), this.decoderContext), (DbContext)this.context())), (long)1L);
        }
        return DbResultDml.create(Stream.of(new DbRow[0]), (long)1L);
    }

    private Long executeUpdate(MongoDbStatement.MongoStatement stmt) {
        MongoCollection mc = this.db().getCollection(stmt.getCollection());
        Document query = stmt.getQuery();
        UpdateResult updateResult = mc.updateMany((Bson)query, (Bson)stmt.getValue());
        return updateResult.getModifiedCount();
    }

    private DbResultDml executeUpdateAsDbResultDml(MongoDbStatement.MongoStatement stmt) {
        BsonValue upsertedId;
        MongoCollection mc = this.db().getCollection(stmt.getCollection());
        Document query = stmt.getQuery();
        UpdateResult result = mc.updateMany((Bson)query, (Bson)stmt.getValue());
        if (this.returnGeneratedKeys && result.wasAcknowledged() && (upsertedId = result.getUpsertedId()) != null) {
            return DbResultDml.create(Stream.of(new MongoDbRow(this.codec.decode((BsonReader)new BsonDocumentReader(new BsonDocument("_id", upsertedId)), this.decoderContext), (DbContext)this.context())), (long)1L);
        }
        return DbResultDml.create(Stream.of(new DbRow[0]), (long)1L);
    }

    private Long executeDelete(MongoDbStatement.MongoStatement stmt) {
        MongoCollection mc = this.db().getCollection(stmt.getCollection());
        Document query = stmt.getQuery();
        DeleteResult deleteResult = mc.deleteMany((Bson)query);
        return deleteResult.getDeletedCount();
    }

    private DbResultDml executeDeleteAsDbResultDml(MongoDbStatement.MongoStatement stmt) {
        return DbResultDml.create(Stream.of(new DbRow[0]), (long)this.executeDelete(stmt));
    }

    private Long executeDml(MongoDbStatement.MongoStatement stmt) {
        switch (stmt.getOperation()) {
            case INSERT: {
                return this.executeInsert(stmt);
            }
            case UPDATE: {
                return this.executeUpdate(stmt);
            }
            case DELETE: {
                return this.executeDelete(stmt);
            }
        }
        throw new UnsupportedOperationException(String.format("Statement operation %s is not supported as DML", new Object[]{stmt.getOperation()}));
    }

    private DbResultDml executeDmlAsDbResultDml(MongoDbStatement.MongoStatement stmt) {
        switch (stmt.getOperation()) {
            case INSERT: {
                return this.executeInsertAsDbResultDml(stmt);
            }
            case UPDATE: {
                return this.executeUpdateAsDbResultDml(stmt);
            }
            case DELETE: {
                return this.executeDeleteAsDbResultDml(stmt);
            }
        }
        throw new UnsupportedOperationException(String.format("Statement operation %s is not supported as DML", new Object[]{stmt.getOperation()}));
    }
}

