/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.client.MongoDatabase;
import io.helidon.dbclient.DbClientContext;
import io.helidon.dbclient.DbExecuteBase;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.mongodb.MongoDbStatementDml;
import io.helidon.dbclient.mongodb.MongoDbStatementGet;
import io.helidon.dbclient.mongodb.MongoDbStatementQuery;

public class MongoDbExecute
extends DbExecuteBase {
    private final MongoDatabase db;

    MongoDbExecute(DbClientContext ctx, MongoDatabase db) {
        super(ctx);
        this.db = db;
    }

    public DbStatementQuery createNamedQuery(String name, String stmt) {
        return new MongoDbStatementQuery(this.db, DbExecuteContext.create((String)name, (String)stmt, (DbClientContext)this.context()));
    }

    public DbStatementGet createNamedGet(String name, String stmt) {
        return new MongoDbStatementGet(this.db, DbExecuteContext.create((String)name, (String)stmt, (DbClientContext)this.context()));
    }

    public DbStatementDml createNamedDmlStatement(String name, String stmt) {
        return new MongoDbStatementDml(this.db, DbStatementType.DML, DbExecuteContext.create((String)name, (String)stmt, (DbClientContext)this.context()));
    }

    public DbStatementDml createNamedInsert(String name, String stmt) {
        return new MongoDbStatementDml(this.db, DbStatementType.INSERT, DbExecuteContext.create((String)name, (String)stmt, (DbClientContext)this.context()));
    }

    public DbStatementDml createNamedUpdate(String name, String stmt) {
        return new MongoDbStatementDml(this.db, DbStatementType.UPDATE, DbExecuteContext.create((String)name, (String)stmt, (DbClientContext)this.context()));
    }

    public DbStatementDml createNamedDelete(String name, String stmt) {
        return new MongoDbStatementDml(this.db, DbStatementType.DELETE, DbExecuteContext.create((String)name, (String)stmt, (DbClientContext)this.context()));
    }

    public <C> C unwrap(Class<C> cls) {
        if (MongoDatabase.class.isAssignableFrom(cls)) {
            return cls.cast(this.db);
        }
        throw new UnsupportedOperationException(String.format("Class %s is not supported for unwrap", cls.getName()));
    }
}

