/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.client.MongoDatabase;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import io.helidon.dbclient.mongodb.MongoDbStatementQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MongoDbStatementGet
extends MongoDbStatement<DbStatementGet>
implements DbStatementGet {
    private final MongoDbStatementQuery theQuery;

    MongoDbStatementGet(MongoDatabase db, DbExecuteContext context) {
        super(db, context);
        this.theQuery = new MongoDbStatementQuery(db, context);
    }

    public DbStatementType statementType() {
        return DbStatementType.GET;
    }

    public MongoDbStatementGet params(List<?> parameters) {
        this.theQuery.params(parameters);
        return this;
    }

    public MongoDbStatementGet params(Map<String, ?> parameters) {
        this.theQuery.params(parameters);
        return this;
    }

    public MongoDbStatementGet namedParam(Object parameters) {
        this.theQuery.namedParam(parameters);
        return this;
    }

    public MongoDbStatementGet indexedParam(Object parameters) {
        this.theQuery.indexedParam(parameters);
        return this;
    }

    public MongoDbStatementGet addParam(Object parameter) {
        this.theQuery.addParam(parameter);
        return this;
    }

    public MongoDbStatementGet addParam(String name, Object parameter) {
        this.theQuery.addParam(name, parameter);
        return this;
    }

    public Optional<DbRow> execute() {
        return this.theQuery.execute().findFirst();
    }
}

