/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbExecuteContext;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbStatementDml
extends MongoDbStatement<DbStatementDml>
implements DbStatementDml {
    private static final System.Logger LOGGER = System.getLogger(MongoDbStatementDml.class.getName());
    private final DbStatementType type;

    MongoDbStatementDml(MongoDatabase db, DbStatementType type, DbExecuteContext context) {
        super(db, context);
        this.type = type;
    }

    public DbStatementType statementType() {
        return this.type;
    }

    public long execute() {
        return (Long)this.doExecute((future, context) -> {
            MongoDbStatement.MongoStatement stmt = new MongoDbStatement.MongoStatement(this.type, this.prepareStatement((DbClientServiceContext)context));
            try {
                long result = switch (this.type) {
                    case DbStatementType.INSERT -> this.executeInsert(stmt);
                    case DbStatementType.UPDATE -> this.executeUpdate(stmt);
                    case DbStatementType.DELETE -> this.executeDelete(stmt);
                    default -> throw new UnsupportedOperationException(String.format("Statement operation not yet supported: %s", this.type.name()));
                };
                future.complete(result);
                LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("%s DML %s execution succeeded", this.type.name(), this.context().statementName()));
                return result;
            }
            catch (UnsupportedOperationException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("%s DML %s execution failed", this.type.name(), this.context().statementName()));
                throw throwable;
            }
        });
    }

    private Long executeInsert(MongoDbStatement.MongoStatement stmt) {
        MongoCollection mc = this.db().getCollection(stmt.getCollection());
        mc.insertOne((Object)stmt.getValue());
        return 1L;
    }

    private Long executeUpdate(MongoDbStatement.MongoStatement stmt) {
        MongoCollection mc = this.db().getCollection(stmt.getCollection());
        Document query = stmt.getQuery();
        UpdateResult updateResult = mc.updateMany((Bson)query, (Bson)stmt.getValue());
        return updateResult.getModifiedCount();
    }

    private Long executeDelete(MongoDbStatement.MongoStatement stmt) {
        MongoCollection mc = this.db().getCollection(stmt.getCollection());
        Document query = stmt.getQuery();
        DeleteResult deleteResult = mc.deleteMany((Bson)query);
        return deleteResult.getDeletedCount();
    }
}

