/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbColumn;
import io.helidon.dbclient.DbContext;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.mongodb.MongoDbColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bson.Document;

final class MongoDbRow
implements DbRow {
    private static final System.Logger LOGGER = System.getLogger(MongoDbRow.class.getName());
    private final Map<String, DbColumn> columnsByName;
    private final List<DbColumn> columnsList;
    private final DbMapperManager dbMapperManager;

    MongoDbRow(Document doc, DbContext context) {
        this.dbMapperManager = context.dbMapperManager();
        int size = doc.size();
        this.columnsByName = new HashMap<String, DbColumn>(size);
        this.columnsList = new ArrayList<DbColumn>(size);
        doc.forEach((name, value) -> {
            LOGGER.log(System.Logger.Level.TRACE, () -> String.format("Column name = %s, value = %s", name, value != null ? value.toString() : "N/A"));
            this.add((String)name, (DbColumn)new MongoDbColumn(context.mapperManager(), (String)name, value));
        });
    }

    void add(String name, DbColumn column) {
        this.columnsByName.put(name, column);
        this.columnsList.add(column);
    }

    public DbColumn column(String name) {
        DbColumn column = this.columnsByName.get(name);
        if (column != null) {
            return column;
        }
        throw new DbClientException(String.format("Column with name %s does not exist", name));
    }

    public DbColumn column(int index) {
        return this.columnsList.get(index - 1);
    }

    public void forEach(Consumer<? super DbColumn> columnAction) {
        this.columnsByName.values().forEach(columnAction);
    }

    public <T> T as(Class<T> type) {
        return (T)this.dbMapperManager.read((DbRow)this, type);
    }

    public <T> T as(GenericType<T> type) throws MapperException {
        return (T)this.dbMapperManager.read((DbRow)this, type);
    }

    public <T> T as(Function<DbRow, T> mapper) {
        return mapper.apply(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('{');
        for (DbColumn col : this.columnsList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(col.name());
            sb.append(':');
            sb.append(col.get().toString());
        }
        sb.append('}');
        return sb.toString();
    }
}

