/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbTransaction;
import io.helidon.dbclient.common.DbClientContext;
import io.helidon.dbclient.mongodb.MongoDbExecute;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import io.helidon.dbclient.mongodb.MongoDbStatementDml;
import io.helidon.dbclient.mongodb.MongoDbStatementGet;
import io.helidon.dbclient.mongodb.MongoDbStatementQuery;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class MongoDbTransaction
extends MongoDbExecute
implements DbTransaction {
    private static final Logger LOGGER = Logger.getLogger(MongoDbTransaction.class.getName());
    private final TransactionManager txManager;

    MongoDbTransaction(MongoDatabase db, ClientSession tx, DbClientContext clientContext) {
        super(db, clientContext);
        this.txManager = new TransactionManager(tx);
    }

    @Override
    public DbStatementQuery createNamedQuery(String statementName, String statement) {
        return (DbStatementQuery)((MongoDbStatementQuery)super.createNamedQuery(statementName, statement)).inTransaction(this.txManager);
    }

    @Override
    public DbStatementGet createNamedGet(String statementName, String statement) {
        return ((MongoDbStatementGet)super.createNamedGet(statementName, statement)).inTransaction(this.txManager);
    }

    @Override
    public DbStatementDml createNamedDmlStatement(String statementName, String statement) {
        return (DbStatementDml)((MongoDbStatementDml)super.createNamedDmlStatement(statementName, statement)).inTransaction(this.txManager);
    }

    @Override
    public DbStatementDml createNamedInsert(String statementName, String statement) {
        return (DbStatementDml)((MongoDbStatementDml)super.createNamedInsert(statementName, statement)).inTransaction(this.txManager);
    }

    @Override
    public DbStatementDml createNamedUpdate(String statementName, String statement) {
        return (DbStatementDml)((MongoDbStatementDml)super.createNamedUpdate(statementName, statement)).inTransaction(this.txManager);
    }

    @Override
    public DbStatementDml createNamedDelete(String statementName, String statement) {
        return (DbStatementDml)((MongoDbStatementDml)super.createNamedDelete(statementName, statement)).inTransaction(this.txManager);
    }

    public void rollback() {
        this.txManager.rollbackOnly();
    }

    TransactionManager txManager() {
        return this.txManager;
    }

    static final class TransactionManager {
        private final ClientSession tx;
        private final AtomicBoolean rollbackOnly;
        private final AtomicBoolean finished;
        private final Set<MongoDbStatement> statements;
        private final Lock lock;

        private TransactionManager(ClientSession tx) {
            this.tx = tx;
            this.tx.startTransaction();
            this.rollbackOnly = new AtomicBoolean(false);
            this.finished = new AtomicBoolean(false);
            this.statements = ConcurrentHashMap.newKeySet();
            this.lock = new ReentrantLock();
        }

        void rollbackOnly() {
            this.lock.lock();
            try {
                this.rollbackOnly.set(false);
            }
            finally {
                this.lock.unlock();
            }
            LOGGER.finest(() -> String.format("Transaction marked as failed", new Object[0]));
        }

        void stmtFinished(MongoDbStatement stmt) {
            this.lock.lock();
            try {
                this.statements.remove((Object)stmt);
                if (this.statements.isEmpty() && this.finished.get()) {
                    this.commitOrRollback();
                }
            }
            finally {
                this.lock.unlock();
            }
            LOGGER.finest(() -> String.format("Statement %s marked as finished in transaction", stmt.statementName()));
        }

        void stmtFailed(MongoDbStatement stmt) {
            this.lock.lock();
            try {
                this.rollbackOnly.set(false);
                this.statements.remove((Object)stmt);
                if (this.statements.isEmpty() && this.finished.get()) {
                    this.tx.abortTransaction();
                }
            }
            finally {
                this.lock.unlock();
            }
            LOGGER.finest(() -> String.format("Statement %s marked as failed in transaction", stmt.statementName()));
        }

        void allRegistered() {
            this.lock.lock();
            try {
                this.finished.set(true);
                if (this.statements.isEmpty()) {
                    this.commitOrRollback();
                }
            }
            finally {
                this.lock.unlock();
            }
            LOGGER.finest(() -> String.format("All statements are registered in current transaction", new Object[0]));
        }

        private void commitOrRollback() {
            if (this.rollbackOnly.get()) {
                this.tx.abortTransaction();
            } else {
                this.tx.commitTransaction();
            }
        }

        ClientSession tx() {
            return this.tx;
        }

        void addStatement(MongoDbStatement stmt) {
            this.statements.add(stmt);
        }
    }
}

