/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbColumnBase;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class JdbcColumn
extends DbColumnBase {
    private static final System.Logger LOGGER = System.getLogger(JdbcColumn.class.getName());
    private final MetaData metaData;

    private JdbcColumn(Object value, MetaData metaData, MapperManager mapperManager) {
        super(value, mapperManager, new String[]{"dbclient"});
        this.metaData = metaData;
    }

    public Class<?> javaType() {
        if (null == this.metaData.javaType()) {
            if (null == this.rawValue()) {
                return null;
            }
            return this.rawValue().getClass();
        }
        return this.metaData.javaType();
    }

    public String dbType() {
        return this.metaData.sqlType();
    }

    public String name() {
        return this.metaData.name();
    }

    static JdbcColumn create(ResultSet rs, MetaData metaData, MapperManager mapperManager, int index) throws SQLException {
        return new JdbcColumn(rs.getObject(index), metaData, mapperManager);
    }

    static final class MetaData {
        private final String name;
        private final String sqlType;
        private final Class<?> javaType;

        private MetaData(String name, String sqlType, Class<?> javaType) {
            this.name = name;
            this.sqlType = sqlType;
            this.javaType = javaType;
        }

        String name() {
            return this.name;
        }

        String sqlType() {
            return this.sqlType;
        }

        Class<?> javaType() {
            return this.javaType;
        }

        static MetaData create(ResultSetMetaData metaData, int index) throws SQLException {
            return new MetaData(metaData.getColumnLabel(index), metaData.getColumnTypeName(index), MetaData.classByName(metaData.getColumnClassName(index)));
        }

        private static Class<?> classByName(String className) {
            if (className == null) {
                return null;
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.log(System.Logger.Level.DEBUG, "Unable to find column class: " + className, (Throwable)ex);
                return null;
            }
        }
    }
}

