/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementException;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.jdbc.JdbcConnectionPool;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcRow;
import io.helidon.dbclient.jdbc.JdbcStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class JdbcStatementQuery
extends JdbcStatement<DbStatementQuery>
implements DbStatementQuery {
    JdbcStatementQuery(JdbcConnectionPool connectionPool, JdbcExecuteContext context) {
        super(connectionPool, context);
    }

    public DbStatementType statementType() {
        return DbStatementType.GET;
    }

    public Stream<DbRow> execute() {
        return (Stream)this.doExecute((future, context) -> JdbcStatementQuery.doExecute(this, future, context, this::closeConnection));
    }

    static Stream<DbRow> doExecute(JdbcStatement<? extends DbStatementQuery> dbStmt, CompletableFuture<Long> future, DbClientServiceContext context, Runnable onClose) {
        try {
            PreparedStatement statement = dbStmt.prepareStatement(context);
            ResultSet rs = statement.executeQuery();
            JdbcRow.Spliterator spliterator = new JdbcRow.Spliterator(rs, statement, dbStmt.context(), future);
            return JdbcStatementQuery.autoClose((Stream)((Stream)StreamSupport.stream(spliterator, false).onClose(() -> {
                spliterator.close();
                if (onClose != null) {
                    onClose.run();
                }
            })));
        }
        catch (SQLException ex) {
            dbStmt.closeConnection();
            throw new DbStatementException("Failed to create Statement", dbStmt.context().statement(), (Throwable)ex);
        }
    }
}

