/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbClientContext;
import io.helidon.dbclient.DbExecuteBase;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.jdbc.JdbcClientContext;
import io.helidon.dbclient.jdbc.JdbcConnectionPool;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatementDml;
import io.helidon.dbclient.jdbc.JdbcStatementGet;
import io.helidon.dbclient.jdbc.JdbcStatementQuery;
import java.sql.Connection;

class JdbcExecute
extends DbExecuteBase {
    private final JdbcConnectionPool connectionPool;

    JdbcExecute(DbClientContext context, JdbcConnectionPool connectionPool) {
        super(context);
        this.connectionPool = connectionPool;
    }

    JdbcConnectionPool connectionPool() {
        return this.connectionPool;
    }

    JdbcClientContext jdbcContext() {
        return (JdbcClientContext)this.context(JdbcClientContext.class);
    }

    public DbStatementQuery createNamedQuery(String stmtName, String stmt) {
        return new JdbcStatementQuery(this.connectionPool, JdbcExecuteContext.jdbcCreate(stmtName, stmt, this.jdbcContext()));
    }

    public DbStatementGet createNamedGet(String stmtName, String stmt) {
        return new JdbcStatementGet(this.connectionPool, JdbcExecuteContext.jdbcCreate(stmtName, stmt, this.jdbcContext()));
    }

    public DbStatementDml createNamedDmlStatement(String stmtName, String stmt) {
        return new JdbcStatementDml(this.connectionPool, DbStatementType.DML, JdbcExecuteContext.jdbcCreate(stmtName, stmt, this.jdbcContext()));
    }

    public DbStatementDml createNamedInsert(String stmtName, String stmt) {
        return new JdbcStatementDml(this.connectionPool, DbStatementType.INSERT, JdbcExecuteContext.jdbcCreate(stmtName, stmt, this.jdbcContext()));
    }

    public DbStatementDml createNamedUpdate(String stmtName, String stmt) {
        return new JdbcStatementDml(this.connectionPool, DbStatementType.UPDATE, JdbcExecuteContext.jdbcCreate(stmtName, stmt, this.jdbcContext()));
    }

    public DbStatementDml createNamedDelete(String stmtName, String stmt) {
        return new JdbcStatementDml(this.connectionPool, DbStatementType.DELETE, JdbcExecuteContext.jdbcCreate(stmtName, stmt, this.jdbcContext()));
    }

    public <C> C unwrap(Class<C> cls) {
        if (Connection.class.isAssignableFrom(cls)) {
            return cls.cast(this.connectionPool.connection());
        }
        throw new UnsupportedOperationException(String.format("Class %s is not supported for unwrap", cls.getName()));
    }
}

