/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbClientContext;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.DbTransaction;
import io.helidon.dbclient.jdbc.JdbcConnectionPool;
import io.helidon.dbclient.jdbc.JdbcExecute;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcTransactionStatementDml;
import io.helidon.dbclient.jdbc.JdbcTransactionStatementGet;
import io.helidon.dbclient.jdbc.JdbcTransactionStatementQuery;
import io.helidon.dbclient.jdbc.TransactionContext;
import java.sql.SQLException;

class JdbcTransaction
extends JdbcExecute
implements DbTransaction {
    private final TransactionContext transactionContext = new TransactionContext(connectionPool::connection);

    JdbcTransaction(DbClientContext context, JdbcConnectionPool connectionPool) {
        super(context, connectionPool);
    }

    @Override
    public DbStatementQuery createNamedQuery(String stmtName, String stmt) {
        return new JdbcTransactionStatementQuery(this.connectionPool(), JdbcExecuteContext.jdbcCreate(stmtName, stmt, this.jdbcContext()), this.transactionContext);
    }

    @Override
    public DbStatementGet createNamedGet(String statementName, String statement) {
        return new JdbcTransactionStatementGet(this.connectionPool(), JdbcExecuteContext.jdbcCreate(statementName, statement, this.jdbcContext()), this.transactionContext);
    }

    @Override
    public DbStatementDml createNamedDmlStatement(String statementName, String statement) {
        return new JdbcTransactionStatementDml(this.connectionPool(), JdbcExecuteContext.jdbcCreate(statementName, statement, this.jdbcContext()), this.transactionContext, DbStatementType.DML);
    }

    @Override
    public DbStatementDml createNamedInsert(String statementName, String statement) {
        return new JdbcTransactionStatementDml(this.connectionPool(), JdbcExecuteContext.jdbcCreate(statementName, statement, this.jdbcContext()), this.transactionContext, DbStatementType.INSERT);
    }

    @Override
    public DbStatementDml createNamedUpdate(String stmtName, String stmt) {
        return new JdbcTransactionStatementDml(this.connectionPool(), JdbcExecuteContext.jdbcCreate(stmtName, stmt, this.jdbcContext()), this.transactionContext, DbStatementType.UPDATE);
    }

    @Override
    public DbStatementDml createNamedDelete(String statementName, String statement) {
        return new JdbcTransactionStatementDml(this.connectionPool(), JdbcExecuteContext.jdbcCreate(statementName, statement, this.jdbcContext()), this.transactionContext, DbStatementType.DELETE);
    }

    public void commit() {
        try {
            this.transactionContext.commit();
        }
        catch (SQLException ex) {
            throw new DbClientException("Failed to commit transaction", (Throwable)ex);
        }
    }

    public void rollback() {
        try {
            this.transactionContext.rollback();
        }
        catch (SQLException ex) {
            throw new DbClientException("Failed to rollback transaction", (Throwable)ex);
        }
    }
}

