/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementException;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.jdbc.JdbcConnectionPool;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;

class JdbcStatementDml
extends JdbcStatement<DbStatementDml>
implements DbStatementDml {
    private final DbStatementType type;

    JdbcStatementDml(JdbcConnectionPool connectionPool, DbStatementType type, JdbcExecuteContext context) {
        super(connectionPool, context);
        this.type = type;
    }

    public DbStatementType statementType() {
        return this.type;
    }

    public long execute() {
        return (Long)this.doExecute((future, context) -> {
            try {
                Long l = JdbcStatementDml.doExecute(this, future, context);
                return l;
            }
            finally {
                this.closeConnection();
            }
        });
    }

    static long doExecute(JdbcStatement<? extends DbStatementDml> dbStmt, CompletableFuture<Long> future, DbClientServiceContext context) {
        long l;
        block8: {
            PreparedStatement statement = dbStmt.prepareStatement(context);
            try {
                long result = statement.executeUpdate();
                future.complete(result);
                l = result;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new DbStatementException("Failed to execute statement", dbStmt.context().statement(), (Throwable)ex);
                }
            }
            statement.close();
        }
        return l;
    }
}

