/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.GenericType;
import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.common.mapper.MapperManager;
import io.helidon.config.Config;
import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.DbMapper;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbStatements;
import io.helidon.dbclient.jdbc.ConnectionPool;
import io.helidon.dbclient.jdbc.JdbcDbClient;
import io.helidon.dbclient.spi.DbClientProviderBuilder;
import io.helidon.dbclient.spi.DbMapperProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public final class JdbcDbClientProviderBuilder
implements DbClientProviderBuilder<JdbcDbClientProviderBuilder> {
    private final DbMapperManager.Builder dbMapperBuilder = DbMapperManager.builder();
    private final List<DbClientService> clientServices = new LinkedList<DbClientService>();
    private String url;
    private String username;
    private String password;
    private DbStatements statements;
    private MapperManager mapperManager;
    private DbMapperManager dbMapperManager;
    private Supplier<ExecutorService> executorService;
    private ConnectionPool connectionPool;

    JdbcDbClientProviderBuilder() {
    }

    public static JdbcDbClientProviderBuilder create() {
        return new JdbcDbClientProviderBuilder();
    }

    public DbClient build() {
        if (null == this.connectionPool) {
            if (null == this.url) {
                throw new DbClientException("No database connection configuration (%s) was found. Use \"connection\" configuration key, or configure on builder using \"connectionPool(ConnectionPool)\"");
            }
            this.connectionPool = ConnectionPool.builder().url(this.url).username(this.username).password(this.password).build();
        }
        if (null == this.dbMapperManager) {
            this.dbMapperManager = this.dbMapperBuilder.build();
        }
        if (null == this.mapperManager) {
            this.mapperManager = MapperManager.create();
        }
        if (null == this.executorService) {
            this.executorService = ThreadPoolSupplier.create((String)"jdbc-dbclient-thread-pool");
        }
        return new JdbcDbClient(this);
    }

    public JdbcDbClientProviderBuilder config(Config config) {
        config.get("connection").detach().ifExists(cfg -> this.connectionPool(ConnectionPool.create(cfg)));
        config.get("statements").as(DbStatements::create).ifPresent(this::statements);
        config.get("executor-service").as(c -> ThreadPoolSupplier.create((Config)c, (String)"jdbc-dbclient-thread-pool")).ifPresent(this::executorService);
        return this;
    }

    public JdbcDbClientProviderBuilder connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    public JdbcDbClientProviderBuilder executorService(Supplier<ExecutorService> executorServiceSupplier) {
        this.executorService = executorServiceSupplier;
        return this;
    }

    public JdbcDbClientProviderBuilder url(String url) {
        this.url = url;
        return this;
    }

    public JdbcDbClientProviderBuilder username(String username) {
        this.username = username;
        return this;
    }

    public JdbcDbClientProviderBuilder password(String password) {
        this.password = password;
        return this;
    }

    public JdbcDbClientProviderBuilder statements(DbStatements statements) {
        this.statements = statements;
        return this;
    }

    public <TYPE> JdbcDbClientProviderBuilder addMapper(final DbMapper<TYPE> dbMapper, final Class<TYPE> mappedClass) {
        this.dbMapperBuilder.addMapperProvider(new DbMapperProvider(){

            public <T> Optional<DbMapper<T>> mapper(Class<T> type) {
                if (type.equals(mappedClass)) {
                    return Optional.of(dbMapper);
                }
                return Optional.empty();
            }
        });
        return this;
    }

    public <TYPE> JdbcDbClientProviderBuilder addMapper(final DbMapper<TYPE> dbMapper, final GenericType<TYPE> mappedType) {
        this.dbMapperBuilder.addMapperProvider(new DbMapperProvider(){

            public <T> Optional<DbMapper<T>> mapper(Class<T> type) {
                return Optional.empty();
            }

            public <T> Optional<DbMapper<T>> mapper(GenericType<T> type) {
                if (type.equals((Object)mappedType)) {
                    return Optional.of(dbMapper);
                }
                return Optional.empty();
            }
        });
        return this;
    }

    public JdbcDbClientProviderBuilder mapperManager(MapperManager manager) {
        this.mapperManager = manager;
        return this;
    }

    public JdbcDbClientProviderBuilder addMapperProvider(DbMapperProvider provider) {
        this.dbMapperBuilder.addMapperProvider(provider);
        return this;
    }

    public JdbcDbClientProviderBuilder addService(DbClientService clientService) {
        this.clientServices.add(clientService);
        return this;
    }

    DbStatements statements() {
        return this.statements;
    }

    List<DbClientService> clientServices() {
        return List.copyOf(this.clientServices);
    }

    DbMapperManager dbMapperManager() {
        return this.dbMapperManager;
    }

    MapperManager mapperManager() {
        return this.mapperManager;
    }

    ExecutorService executorService() {
        return this.executorService.get();
    }

    ConnectionPool connectionPool() {
        return this.connectionPool;
    }
}

