/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.dbclient.common.DbClientContext;
import java.sql.Connection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

final class JdbcExecuteContext
extends DbClientContext {
    private final ConcurrentHashMap.KeySetView<CompletableFuture<Long>, Boolean> futures = ConcurrentHashMap.newKeySet();
    private final ExecutorService executorService;
    private final String dbType;
    private final CompletionStage<Connection> connection;

    private JdbcExecuteContext(Builder builder) {
        super((DbClientContext.BuilderBase)builder);
        this.executorService = builder.executorService;
        this.dbType = builder.dbType;
        this.connection = builder.connection;
    }

    static Builder jdbcBuilder() {
        return new Builder();
    }

    ExecutorService executorService() {
        return this.executorService;
    }

    String dbType() {
        return this.dbType;
    }

    CompletionStage<Connection> connection() {
        return this.connection;
    }

    void addFuture(CompletableFuture<Long> queryFuture) {
        this.futures.add(queryFuture);
    }

    CompletionStage<Void> whenComplete() {
        CompletionStage<Object> overallStage = CompletableFuture.completedFuture(null);
        for (CompletableFuture<Long> future : this.futures) {
            overallStage = overallStage.thenCompose(o -> future);
        }
        return overallStage.thenAccept(it -> {});
    }

    static class Builder
    extends DbClientContext.BuilderBase<Builder>
    implements io.helidon.common.Builder<Builder, JdbcExecuteContext> {
        private ExecutorService executorService;
        private String dbType;
        private CompletionStage<Connection> connection;

        Builder() {
        }

        public JdbcExecuteContext build() {
            return new JdbcExecuteContext(this);
        }

        Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        Builder dbType(String dbType) {
            this.dbType = dbType;
            return this;
        }

        Builder connection(CompletionStage<Connection> connection) {
            this.connection = connection;
            return this;
        }
    }
}

