/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.reactive.Single;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.common.DbStatementContext;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.CompletableFuture;

class JdbcStatementDml
extends JdbcStatement<DbStatementDml, Single<Long>>
implements DbStatementDml {
    JdbcStatementDml(JdbcExecuteContext executeContext, DbStatementContext statementContext) {
        super(executeContext, statementContext);
    }

    protected Single<Long> doExecute(Single<DbClientServiceContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        this.executeContext().addFuture(queryFuture);
        dbContextFuture.exceptionally(throwable -> {
            statementFuture.completeExceptionally((Throwable)throwable);
            queryFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        return dbContextFuture.flatMapSingle(dbContext -> this.doExecute((DbClientServiceContext)dbContext, statementFuture, queryFuture));
    }

    private Single<Long> doExecute(DbClientServiceContext dbContext, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        this.executorService().submit(() -> this.connection().thenAccept(conn -> this.callStatement(dbContext, (Connection)conn, statementFuture, queryFuture)).exceptionally(t -> {
            statementFuture.completeExceptionally((Throwable)t);
            queryFuture.completeExceptionally((Throwable)t);
            return null;
        }));
        return Single.create(queryFuture);
    }

    private void callStatement(DbClientServiceContext dbContext, Connection connection, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        try {
            PreparedStatement preparedStatement = this.build(connection, dbContext);
            long count = preparedStatement.executeLargeUpdate();
            statementFuture.complete(null);
            queryFuture.complete(count);
            preparedStatement.close();
        }
        catch (Exception e) {
            statementFuture.completeExceptionally(e);
            queryFuture.completeExceptionally(e);
        }
    }
}

