/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

class JdbcQueryExecutor {
    private final Random random = new Random();
    private final List<StmtRunnable> runnables = new ArrayList<StmtRunnable>();

    JdbcQueryExecutor() {
    }

    void submit(QueryProcessor processor) {
        for (StmtRunnable runnable : this.runnables) {
            if (!runnable.processors.isEmpty()) continue;
            runnable.addProcessor(processor);
            return;
        }
        for (StmtRunnable runnable : this.runnables) {
            if (!runnable.idle.get()) continue;
            runnable.addProcessor(processor);
            return;
        }
        this.runnables.get(this.random.nextInt(this.runnables.size())).addProcessor(processor);
    }

    private static class StmtRunnable
    implements Runnable {
        private final Set<QueryProcessor> processors = Collections.newSetFromMap(new IdentityHashMap());
        private final AtomicBoolean idle = new AtomicBoolean();
        private final AtomicBoolean enabled = new AtomicBoolean(true);

        private StmtRunnable() {
        }

        void addProcessor(QueryProcessor processor) {
            this.processors.add(processor);
            this.requestRun();
        }

        void requestRun() {
        }

        @Override
        public void run() {
            while (this.enabled.get()) {
                this.idle.set(true);
                this.idle.set(false);
                boolean working = true;
                while (working) {
                    working = false;
                    LinkedList<QueryProcessor> toRemove = new LinkedList<QueryProcessor>();
                    for (QueryProcessor processor : this.processors) {
                        if (processor.isCompleted()) {
                            toRemove.add(processor);
                            continue;
                        }
                        if (!processor.tryNext()) continue;
                        working = true;
                    }
                    toRemove.forEach(this.processors::remove);
                }
            }
        }
    }

    static interface QueryProcessor {
        public boolean tryNext();

        public boolean isCompleted();
    }
}

