/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import io.helidon.common.mapper.MapperManager;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.Subscribable;
import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.DbStatements;
import io.helidon.dbclient.DbTransaction;
import io.helidon.dbclient.common.AbstractDbExecute;
import io.helidon.dbclient.common.DbClientContext;
import io.helidon.dbclient.common.DbStatementContext;
import io.helidon.dbclient.jdbc.ConnectionPool;
import io.helidon.dbclient.jdbc.JdbcDbClientProviderBuilder;
import io.helidon.dbclient.jdbc.JdbcExecuteContext;
import io.helidon.dbclient.jdbc.JdbcStatementDml;
import io.helidon.dbclient.jdbc.JdbcStatementGet;
import io.helidon.dbclient.jdbc.JdbcStatementQuery;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

class JdbcDbClient
implements DbClient {
    private static final Logger LOGGER = Logger.getLogger(DbClient.class.getName());
    private final ExecutorService executorService;
    private final ConnectionPool connectionPool;
    private final DbStatements statements;
    private final DbMapperManager dbMapperManager;
    private final MapperManager mapperManager;
    private final List<DbClientService> clientServices;

    JdbcDbClient(JdbcDbClientProviderBuilder builder) {
        this.executorService = builder.executorService();
        this.connectionPool = builder.connectionPool();
        this.statements = builder.statements();
        this.dbMapperManager = builder.dbMapperManager();
        this.mapperManager = builder.mapperManager();
        this.clientServices = builder.clientServices();
    }

    public <U, T extends Subscribable<U>> T inTransaction(Function<DbTransaction, T> executor) {
        JdbcTxExecute execute = new JdbcTxExecute(this.statements, this.executorService, this.clientServices, this.connectionPool, this.dbMapperManager, this.mapperManager);
        Subscribable result = (Subscribable)executor.apply(execute);
        if (result instanceof Multi) {
            Multi multi = (Multi)result;
            CompletableFuture commitFuture = new CompletableFuture();
            multi = multi.onComplete(() -> execute.doCommit().thenAccept(it -> commitFuture.complete(Multi.empty())).exceptionally(it -> {
                commitFuture.complete(Multi.error((Throwable)it));
                return null;
            }));
            multi = multi.onCompleteResumeWith((Flow.Publisher)Single.create(commitFuture).flatMap(Function.identity()));
            multi = multi.onError(throwable -> RollbackHandler.create(execute, Level.WARNING).apply((Throwable)throwable));
            return (T)multi;
        }
        if (result instanceof Single) {
            Single single = (Single)result;
            return (T)single.flatMapSingle(it -> Single.create(execute.doCommit().thenApply(unused -> it))).onError(RollbackHandler.create(execute, Level.WARNING)::apply);
        }
        execute.doRollback();
        throw new IllegalStateException("You must return a Single or Multi instance to inTransaction, yet you provided: " + result.getClass().getName());
    }

    public <U, T extends Subscribable<U>> T execute(Function<DbExecute, T> executor) {
        Subscribable result;
        JdbcExecute execute = new JdbcExecute(this.statements, JdbcExecute.createContext(this.statements, this.executorService, this.clientServices, this.connectionPool, this.dbMapperManager, this.mapperManager));
        try {
            result = (Subscribable)executor.apply((DbExecute)execute);
        }
        catch (RuntimeException e) {
            execute.close();
            throw e;
        }
        result = result.onComplete(() -> execute.context().whenComplete().thenAccept(nothing -> {
            LOGGER.finest(() -> "Execution finished, closing connection");
            execute.close();
        }).exceptionally(throwable -> {
            LOGGER.log(Level.WARNING, (Throwable)throwable, () -> String.format("Execution failed: %s", throwable.getMessage()));
            execute.close();
            return null;
        }));
        result = result.onError(throwable -> {
            LOGGER.log(Level.FINEST, (Throwable)throwable, () -> String.format("Execution failed: %s", throwable.getMessage()));
            execute.close();
        });
        return (T)result;
    }

    public Single<Void> ping() {
        return this.execute(exec -> exec.namedUpdate("ping", new Object[0])).flatMapSingle(it -> Single.empty());
    }

    public String dbType() {
        return this.connectionPool.dbType();
    }

    private static class JdbcExecute
    extends AbstractDbExecute {
        private final JdbcExecuteContext context;

        private JdbcExecute(DbStatements statements, JdbcExecuteContext context) {
            super(statements);
            this.context = context;
        }

        private static JdbcExecuteContext createContext(DbStatements statements, ExecutorService executorService, List<DbClientService> clientServices, ConnectionPool connectionPool, DbMapperManager dbMapperManager, MapperManager mapperManager) {
            CompletionStage connection = CompletableFuture.supplyAsync(connectionPool::connection, executorService).thenApply(conn -> {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException e) {
                    throw new DbClientException("Failed to set autocommit to true", (Throwable)e);
                }
                return conn;
            });
            return ((JdbcExecuteContext.Builder)((JdbcExecuteContext.Builder)((JdbcExecuteContext.Builder)((JdbcExecuteContext.Builder)JdbcExecuteContext.jdbcBuilder().statements(statements)).executorService(executorService).connection(connection).clientServices(clientServices)).dbMapperManager(dbMapperManager)).mapperManager(mapperManager)).dbType(connectionPool.dbType()).build();
        }

        public DbStatementQuery createNamedQuery(String statementName, String statement) {
            return new JdbcStatementQuery(this.context, DbStatementContext.create((DbClientContext)this.context, (DbStatementType)DbStatementType.QUERY, (String)statementName, (String)statement));
        }

        public DbStatementGet createNamedGet(String statementName, String statement) {
            return new JdbcStatementGet(this.context, DbStatementContext.create((DbClientContext)this.context, (DbStatementType)DbStatementType.GET, (String)statementName, (String)statement));
        }

        public DbStatementDml createNamedDmlStatement(String statementName, String statement) {
            return new JdbcStatementDml(this.context, DbStatementContext.create((DbClientContext)this.context, (DbStatementType)DbStatementType.DML, (String)statementName, (String)statement));
        }

        public DbStatementDml createNamedInsert(String statementName, String statement) {
            return new JdbcStatementDml(this.context, DbStatementContext.create((DbClientContext)this.context, (DbStatementType)DbStatementType.INSERT, (String)statementName, (String)statement));
        }

        public DbStatementDml createNamedUpdate(String statementName, String statement) {
            return new JdbcStatementDml(this.context, DbStatementContext.create((DbClientContext)this.context, (DbStatementType)DbStatementType.UPDATE, (String)statementName, (String)statement));
        }

        public DbStatementDml createNamedDelete(String statementName, String statement) {
            return new JdbcStatementDml(this.context, DbStatementContext.create((DbClientContext)this.context, (DbStatementType)DbStatementType.DELETE, (String)statementName, (String)statement));
        }

        JdbcExecuteContext context() {
            return this.context;
        }

        void close() {
            this.context.connection().thenAccept(conn -> {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, e, () -> String.format("Could not close connection: %s", e.getMessage()));
                }
            });
        }
    }

    private static final class JdbcTxExecute
    extends JdbcExecute
    implements DbTransaction {
        private volatile boolean setRollbackOnly = false;

        private JdbcTxExecute(DbStatements statements, ExecutorService executorService, List<DbClientService> clientServices, ConnectionPool connectionPool, DbMapperManager dbMapperManager, MapperManager mapperManager) {
            super(statements, ((JdbcExecuteContext.Builder)((JdbcExecuteContext.Builder)((JdbcExecuteContext.Builder)((JdbcExecuteContext.Builder)JdbcExecuteContext.jdbcBuilder().statements(statements)).clientServices(clientServices)).dbType(connectionPool.dbType()).connection(JdbcTxExecute.createConnection(executorService, connectionPool)).dbMapperManager(dbMapperManager)).mapperManager(mapperManager)).executorService(executorService).build());
        }

        private static CompletionStage<Connection> createConnection(ExecutorService executorService, ConnectionPool connectionPool) {
            return CompletableFuture.supplyAsync(connectionPool::connection, executorService).thenApply(conn -> {
                try {
                    conn.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new DbClientException("Failed to set autocommit to false", (Throwable)e);
                }
                return conn;
            });
        }

        public void rollback() {
            this.setRollbackOnly = true;
        }

        private CompletionStage<Void> doRollback() {
            return this.context().connection().thenApply(conn -> {
                try {
                    conn.rollback();
                    conn.close();
                }
                catch (SQLException e) {
                    throw new DbClientException("Failed to rollback a transaction, or close a connection", (Throwable)e);
                }
                return null;
            });
        }

        private CompletionStage<Void> doCommit() {
            if (this.setRollbackOnly) {
                return this.doRollback();
            }
            return this.context().connection().thenApply(conn -> {
                try {
                    conn.commit();
                    conn.close();
                }
                catch (SQLException e) {
                    throw new DbClientException("Failed to commit a transaction, or close a connection", (Throwable)e);
                }
                return null;
            });
        }
    }

    private static final class RollbackHandler<T>
    implements Function<Throwable, T> {
        private final JdbcTxExecute execute;
        private final Level level;

        private static <T> RollbackHandler<T> create(JdbcTxExecute execute, Level level) {
            return new RollbackHandler<T>(execute, level);
        }

        private RollbackHandler(JdbcTxExecute execute, Level level) {
            this.execute = execute;
            this.level = level;
        }

        @Override
        public T apply(Throwable t) {
            LOGGER.log(this.level, t, () -> String.format("Transaction rollback: %s", t.getMessage()));
            this.execute.doRollback().exceptionally(t2 -> {
                LOGGER.log(this.level, (Throwable)t2, () -> String.format("Transaction rollback failed: %s", t2.getMessage()));
                return null;
            });
            return null;
        }
    }
}

