/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.jdbc.ConnectionPool;
import io.helidon.dbclient.jdbc.HikariCpExtension;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class HikariConnectionPool
implements ConnectionPool {
    private final HikariDataSource dataSource;
    private final String dbType;

    HikariConnectionPool(ConnectionPool.Builder builder, String dbType, List<HikariCpExtension> extensions) {
        this.dbType = dbType;
        HikariConfig config = new HikariConfig(builder.properties());
        config.setJdbcUrl(builder.url());
        config.setUsername(builder.username());
        config.setPassword(builder.password());
        extensions.forEach(interceptor -> interceptor.configure(config));
        this.dataSource = new HikariDataSource(config);
    }

    @Override
    public Connection connection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new DbClientException(String.format("Failed to create a connection to %s", this.dataSource.getJdbcUrl()), (Throwable)ex);
        }
    }

    @Override
    public String dbType() {
        return this.dbType;
    }
}

