/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.common;

import io.helidon.builder.api.GeneratedBuilder;
import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.data.sql.common.ConnectionConfigBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.sql.common.ConnectionConfigBlueprint")
public interface ConnectionConfig
extends ConnectionConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectionConfig instance) {
        return (Builder)ConnectionConfig.builder().from(instance);
    }

    public static ConnectionConfig create(Config config) {
        return ((Builder)ConnectionConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static ConnectionConfig create(io.helidon.common.config.Config config) {
        return ConnectionConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    @Override
    public String url();

    @Override
    public Optional<String> username();

    @Override
    public Optional<char[]> password();

    @Override
    public Optional<String> jdbcDriverClassName();

    public static class Builder
    extends BuilderBase<Builder, ConnectionConfig>
    implements io.helidon.common.Builder<Builder, ConnectionConfig> {
        private Builder() {
        }

        public ConnectionConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ConnectionConfigImpl(this);
        }

        public ConnectionConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ConnectionConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private char[] password;
        private Config config;
        private String jdbcDriverClassName;
        private String url;
        private String username;

        protected BuilderBase() {
        }

        public BUILDER from(ConnectionConfig prototype) {
            this.url(prototype.url());
            this.username(prototype.username());
            this.password(prototype.password());
            this.jdbcDriverClassName(prototype.jdbcDriverClassName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.url().ifPresent(this::url);
            builder.username().ifPresent(this::username);
            builder.password().ifPresent(this::password);
            builder.jdbcDriverClassName().ifPresent(this::jdbcDriverClassName);
            this.config = builder.config().map(Config::config).orElse(this.config);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("url").asString().ifPresent(this::url);
            config.get("username").asString().ifPresent(this::username);
            config.get("password").asString().as(String::toCharArray).ifPresent(this::password);
            config.get("jdbc-driver-class-name").asString().ifPresent(this::jdbcDriverClassName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER url(String url) {
            Objects.requireNonNull(url);
            this.url = url;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearUsername() {
            this.username = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER username(String username) {
            Objects.requireNonNull(username);
            this.username = username;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPassword() {
            this.password = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER password(String password) {
            Objects.requireNonNull(password);
            this.password(password.toCharArray());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER password(char[] password) {
            this.password = password;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearJdbcDriverClassName() {
            this.jdbcDriverClassName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER jdbcDriverClassName(String jdbcDriverClassName) {
            Objects.requireNonNull(jdbcDriverClassName);
            this.jdbcDriverClassName = jdbcDriverClassName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> url() {
            return Optional.ofNullable(this.url);
        }

        public Optional<String> username() {
            return Optional.ofNullable(this.username);
        }

        public Optional<char[]> password() {
            return Optional.ofNullable(this.password);
        }

        public Optional<String> jdbcDriverClassName() {
            return Optional.ofNullable(this.jdbcDriverClassName);
        }

        public String toString() {
            return "ConnectionConfigBuilder{url=" + this.url + ",username=" + this.username + ",password=" + (this.password == null ? "null" : "****") + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.url == null) {
                collector.fatal(this.getClass(), "Property \"url\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        BUILDER username(Optional<String> username) {
            Objects.requireNonNull(username);
            this.username = username.orElse(this.username);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER password(Optional<char[]> password) {
            Objects.requireNonNull(password);
            this.password = password.orElse(this.password);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER jdbcDriverClassName(Optional<String> jdbcDriverClassName) {
            Objects.requireNonNull(jdbcDriverClassName);
            this.jdbcDriverClassName = jdbcDriverClassName.orElse(this.jdbcDriverClassName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ConnectionConfigImpl
        implements ConnectionConfig {
            private final Optional<char[]> password;
            private final Optional<String> jdbcDriverClassName;
            private final Optional<String> username;
            private final String url;

            protected ConnectionConfigImpl(BuilderBase<?, ?> builder) {
                this.url = builder.url().get();
                this.username = builder.username().map(Function.identity());
                this.password = builder.password().map(Function.identity());
                this.jdbcDriverClassName = builder.jdbcDriverClassName().map(Function.identity());
            }

            @Override
            public String url() {
                return this.url;
            }

            @Override
            public Optional<String> username() {
                return this.username;
            }

            @Override
            public Optional<char[]> password() {
                return this.password;
            }

            @Override
            public Optional<String> jdbcDriverClassName() {
                return this.jdbcDriverClassName;
            }

            public String toString() {
                return "ConnectionConfig{url=" + this.url + ",username=" + String.valueOf(this.username) + ",password=" + (this.password.isPresent() ? "****" : "null") + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ConnectionConfig)) {
                    return false;
                }
                ConnectionConfig other = (ConnectionConfig)o;
                return Objects.equals(this.url, other.url()) && Objects.equals(this.username, other.username()) && GeneratedBuilder.EqualityUtil.optionalCharArrayEquals(this.password, other.password());
            }

            public int hashCode() {
                return Objects.hash(this.url, this.username) + 31 * GeneratedBuilder.EqualityUtil.optionalCharArrayHash(this.password);
            }
        }
    }
}

