/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.jdbc;

import io.helidon.data.sql.common.ConnectionConfig;
import io.helidon.data.sql.common.SqlDriver;
import io.helidon.data.sql.datasource.DataSourceConfig;
import io.helidon.data.sql.datasource.ProviderConfig;
import io.helidon.data.sql.datasource.jdbc.JdbcDataSource;
import io.helidon.data.sql.datasource.jdbc.JdbcDataSourceConfig;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;

@Service.Singleton
class JdbcDataSourceService
implements Service.ServicesFactory<DataSource> {
    private final Supplier<List<DataSourceConfig>> dsConfigs;

    @Service.Inject
    JdbcDataSourceService(Supplier<List<DataSourceConfig>> dsConfigs) {
        this.dsConfigs = dsConfigs;
    }

    public List<Service.QualifiedInstance<DataSource>> services() {
        ArrayList<Service.QualifiedInstance<DataSource>> instances = new ArrayList<Service.QualifiedInstance<DataSource>>();
        for (DataSourceConfig dsConfig : this.dsConfigs.get()) {
            ProviderConfig providerConfig = dsConfig.provider();
            if (!(providerConfig instanceof JdbcDataSourceConfig)) continue;
            JdbcDataSourceConfig jdbcConfig = (JdbcDataSourceConfig)providerConfig;
            String name = dsConfig.name();
            instances.add(this.createNamedDataSource(name, jdbcConfig));
        }
        return instances;
    }

    private Service.QualifiedInstance<DataSource> createNamedDataSource(String name, JdbcDataSourceConfig providerConfig) {
        return Service.QualifiedInstance.create((Object)this.createDataSource(providerConfig), (Qualifier[])new Qualifier[]{Qualifier.createNamed((String)name)});
    }

    private DataSource createDataSource(JdbcDataSourceConfig providerConfig) {
        SqlDriver driver = SqlDriver.create((ConnectionConfig)providerConfig);
        if (driver instanceof DataSource) {
            DataSource ds = (DataSource)driver;
            return ds;
        }
        return new JdbcDataSource(providerConfig, driver);
    }
}

