/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.sql.datasource.hikari;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.data.sql.common.ConnectionConfig;
import io.helidon.data.sql.datasource.ProviderConfig;
import io.helidon.data.sql.datasource.TransactionIsolation;
import io.helidon.data.sql.datasource.spi.DataSourceConfigProvider;
import java.util.Map;
import java.util.Optional;

@Prototype.Blueprint
@Prototype.Configured(root=false, value="hikari")
@Prototype.Provides(value={DataSourceConfigProvider.class})
interface HikariDataSourceConfigBlueprint
extends ConnectionConfig,
ProviderConfig {
    default public String type() {
        return "hikari";
    }

    public String name();

    @Option.Configured
    public Optional<Boolean> allowPoolSuspension();

    @Option.Configured
    public Optional<Boolean> autoCommit();

    @Option.Configured
    public Optional<String> catalog();

    @Option.Configured
    public Optional<String> connectionInitSql();

    @Option.Configured
    public Optional<String> connectionTestQuery();

    @Option.Configured
    public Optional<Long> connectionTimeout();

    @Option.Configured
    @Option.Singular(value="healthCheckProperty")
    public Map<String, String> healthCheckProperties();

    @Option.Configured
    public Optional<Long> idleTimeout();

    @Option.Configured
    public Optional<Long> initializationFailTimeout();

    @Option.Configured
    public Optional<Boolean> isolateInternalQueries();

    @Option.Configured
    public Optional<Long> keepaliveTime();

    @Option.Configured
    public Optional<Long> leakDetectionThreshold();

    @Option.Configured
    public Optional<Integer> maximumPoolSize();

    @Option.Configured
    public Optional<Long> maxLifetime();

    @Option.Configured
    public Optional<Integer> minimumIdle();

    @Option.Configured
    public Optional<String> poolName();

    @Option.Configured
    public Optional<Boolean> readOnly();

    @Option.Configured
    public Optional<Boolean> registerMbeans();

    @Option.Configured
    public Optional<String> schema();

    @Option.Configured
    public Optional<TransactionIsolation> transactionIsolation();

    @Option.Configured
    public Optional<Long> validationTimeout();

    @Option.Configured
    @Option.Singular(value="property")
    public Map<String, String> properties();
}

