/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.jakarta.persistence.codegen;

class JpqlKeywords {
    static final char SPACE = ' ';
    static final char DOT = '.';
    static final char COMMA = ',';
    static final char COLON = ':';
    static final char LEFT_BRACKET = '(';
    static final char RIGHT_BRACKET = ')';
    static final char PERCENT = '%';
    static final char APOSTROPHE = '\'';
    static final char DOUBLE_QUOTE = '\"';
    static final String SELECT = "SELECT";
    static final String DELETE = "DELETE";
    static final String UPDATE = "UPDATE";
    static final String COUNT = "COUNT";
    static final String MAX = "MAX";
    static final String MIN = "MIN";
    static final String SUM = "SUM";
    static final String AVG = "AVG";
    static final String WHERE = "WHERE";
    static final String FROM = "FROM";
    static final String DISTINCT = "DISTINCT";
    static final String NOT = "NOT";
    static final String AND = "AND";
    static final String OR = "OR";
    static final char EQUAL = '=';
    static final String NOT_EQUAL = "<>";
    static final char LESS_THAN = '<';
    static final String LESS_THAN_EQUAL = "<=";
    static final char GREATER_THAN = '>';
    static final String GREATER_THAN_EQUAL = ">=";
    static final String LIKE = "LIKE";
    static final String CONCAT = "CONCAT";
    static final String BETWEEN = "BETWEEN";
    static final String IN = "IN";
    static final String IS = "IS";
    static final String EMPTY = "EMPTY";
    static final String UPPER = "UPPER";
    static final String NULL = "NULL";
    static final String TRUE = "TRUE";
    static final String FALSE = "FALSE";
    static final String ORDER_BY = "ORDER BY";
    static final String ASC = "ASC";
    static final String DESC = "DESC";

    private JpqlKeywords() {
        throw new UnsupportedOperationException("No instances of JpqlKeywords are allowed");
    }

    static void count(StringBuilder builder, CharSequence param) {
        JpqlKeywords.function(builder, param, COUNT);
    }

    static void max(StringBuilder builder, CharSequence param) {
        JpqlKeywords.function(builder, param, MAX);
    }

    static void min(StringBuilder builder, CharSequence param) {
        JpqlKeywords.function(builder, param, MIN);
    }

    static void avg(StringBuilder builder, CharSequence param) {
        JpqlKeywords.function(builder, param, AVG);
    }

    static void sum(StringBuilder builder, CharSequence param) {
        JpqlKeywords.function(builder, param, SUM);
    }

    static void maybeNot(StringBuilder builder, boolean not) {
        if (not) {
            builder.append(' ').append(NOT);
        }
    }

    static void maybeComma(StringBuilder builder, boolean comma) {
        if (comma) {
            builder.append(',').append(' ');
        }
    }

    static void property(StringBuilder builder, CharSequence entityAlias, CharSequence property, boolean ignoreCase) {
        if (ignoreCase) {
            builder.append(UPPER).append("(").append(entityAlias).append('.').append(property).append(")");
        } else {
            builder.append(entityAlias).append('.').append(property);
        }
    }

    static void property(StringBuilder builder, CharSequence entityAlias, CharSequence property) {
        JpqlKeywords.property(builder, entityAlias, property, false);
    }

    static void param(StringBuilder builder, CharSequence param, boolean ignoreCase) {
        if (ignoreCase) {
            builder.append(UPPER).append("(").append(':').append(param).append(")");
        } else {
            builder.append(':').append(param);
        }
    }

    static void param(StringBuilder builder, CharSequence param) {
        JpqlKeywords.param(builder, param, false);
    }

    private static void function(StringBuilder builder, CharSequence param, CharSequence functionName) {
        builder.append(functionName).append('(').append(param).append(')');
    }
}

