/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.jakarta.persistence.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.common.Builder;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.query.DataQuery;
import io.helidon.data.codegen.query.ProjectionExpression;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceBaseBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

abstract class JakartaPersistenceBaseQueryBuilder
extends JakartaPersistenceBaseBuilder {
    JakartaPersistenceBaseQueryBuilder(RepositoryInfo repositoryInfo) {
        super(repositoryInfo);
    }

    static PersistenceGenerator.QueryReturnType queryReturntype(DataQuery query) {
        if (query.projection().expression().isPresent()) {
            ProjectionExpression expression = (ProjectionExpression)query.projection().expression().get();
            switch (expression.operator()) {
                case First: {
                    return PersistenceGenerator.QueryReturnType.ENTITY;
                }
                case Exists: {
                    return PersistenceGenerator.QueryReturnType.BOOLEAN;
                }
                case Count: 
                case Min: 
                case Max: 
                case Sum: 
                case Avg: {
                    return PersistenceGenerator.QueryReturnType.NUMBER;
                }
            }
            throw new CodegenException("Unknown projection expression operator " + String.valueOf(expression.operator()));
        }
        return PersistenceGenerator.QueryReturnType.ENTITY;
    }

    static final class Query
    extends BaseQuery
    implements PersistenceGenerator.Query {
        private final String query;

        private Query(String query, List<PersistenceGenerator.QuerySettings> settings, PersistenceGenerator.QueryReturnType returnType, boolean isDml) {
            super(settings, returnType, isDml);
            Objects.requireNonNull(query, "Query statement value is null");
            this.query = query;
        }

        static Builder builder() {
            return new Builder();
        }

        public String query() {
            return this.query;
        }

        static class Builder
        extends BaseQuery.BaseBuilder<Builder, Query>
        implements io.helidon.common.Builder<Builder, Query> {
            private String query = null;

            private Builder() {
            }

            public Query build() {
                return new Query(this.query, List.copyOf(this.settings()), this.returnType(), this.isDml());
            }

            Builder query(String query) {
                this.query = query;
                return this;
            }
        }
    }

    static abstract class BaseQuery {
        private final List<PersistenceGenerator.QuerySettings> settings;
        private final PersistenceGenerator.QueryReturnType returnType;
        private final boolean isDml;

        private BaseQuery(List<PersistenceGenerator.QuerySettings> settings, PersistenceGenerator.QueryReturnType returnType, boolean isDml) {
            Objects.requireNonNull(settings, "Query setting value is null");
            Objects.requireNonNull(returnType, "Query return type value is null");
            this.settings = settings;
            this.returnType = returnType;
            this.isDml = isDml;
        }

        public List<PersistenceGenerator.QuerySettings> settings() {
            return this.settings;
        }

        public PersistenceGenerator.QueryReturnType returnType() {
            return this.returnType;
        }

        public boolean isDml() {
            return this.isDml;
        }

        static abstract class BaseBuilder<B extends BaseBuilder<B, Q>, Q extends BaseQuery>
        implements Builder<B, Q> {
            private final List<PersistenceGenerator.QuerySettings> settings = new ArrayList<PersistenceGenerator.QuerySettings>();
            private PersistenceGenerator.QueryReturnType returnType = null;
            private boolean isDml = false;

            private BaseBuilder() {
            }

            B setting(PersistenceGenerator.QuerySettings setting) {
                this.settings.add(setting);
                return (B)((BaseBuilder)this.identity());
            }

            B returnType(PersistenceGenerator.QueryReturnType returnType) {
                this.returnType = returnType;
                return (B)((BaseBuilder)this.identity());
            }

            B isDml(boolean isDml) {
                this.isDml = isDml;
                return (B)((BaseBuilder)this.identity());
            }

            List<PersistenceGenerator.QuerySettings> settings() {
                return this.settings;
            }

            PersistenceGenerator.QueryReturnType returnType() {
                return this.returnType;
            }

            boolean isDml() {
                return this.isDml;
            }
        }
    }
}

