/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.jakarta.persistence.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.codegen.spi.CodegenExtensionProvider;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceTypes;
import java.util.Collection;
import java.util.Set;

public class EntityCodegenProvider
implements CodegenExtensionProvider {
    public CodegenExtension create(CodegenContext codegenContext, TypeName typeName) {
        return new EntityCodegen();
    }

    public Set<TypeName> supportedAnnotations() {
        return Set.of(JakartaPersistenceTypes.ENTITY);
    }

    private static final class EntityCodegen
    implements CodegenExtension {
        private static final TypeName GENERATOR = TypeName.create(EntityCodegen.class);

        private EntityCodegen() {
        }

        public void process(RoundContext roundContext) {
            Collection typeInfos = roundContext.annotatedTypes(JakartaPersistenceTypes.ENTITY);
            for (TypeInfo typeInfo : typeInfos) {
                this.createProvider(roundContext, typeInfo);
            }
        }

        private void createProvider(RoundContext roundContext, TypeInfo typeInfo) {
            TypeName trigger = typeInfo.typeName();
            TypeName generatedType = this.generatedEntityProviderType(trigger);
            ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)trigger, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)trigger, (TypeName)generatedType, (String)"1", (String)""))).accessModifier(AccessModifier.PACKAGE_PRIVATE).description("Entity provider for {@link " + trigger.fqName() + "}.")).type(generatedType).addInterface(this.providerInterfaceType(trigger))).addAnnotation(JakartaPersistenceTypes.INJECTION_SINGLETON);
            classModel.addConstructor(ctr -> ctr.accessModifier(AccessModifier.PACKAGE_PRIVATE));
            classModel.addMethod(entityClass -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)entityClass.name("entityClass")).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(this.entityClassType(trigger)).addContent("return ")).addContent(trigger)).addContentLine(".class;"));
            roundContext.addGeneratedType(generatedType, classModel, trigger, new Object[]{typeInfo.originatingElementValue()});
        }

        private TypeName entityClassType(TypeName trigger) {
            return ((TypeName.Builder)TypeName.builder((TypeName)TypeName.create(Class.class)).addTypeArgument(trigger)).build();
        }

        private TypeName generatedEntityProviderType(TypeName trigger) {
            return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(trigger.packageName())).className(trigger.classNameWithEnclosingNames() + "__EntityProvider")).build();
        }

        private TypeName providerInterfaceType(TypeName trigger) {
            return ((TypeName.Builder)TypeName.builder((TypeName)JakartaPersistenceTypes.ENTITY_PROVIDER).addTypeArgument(trigger)).build();
        }
    }
}

