/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.data.OrderBlueprint;
import io.helidon.data.OrderDirection;
import io.helidon.data.OrderSupport;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.OrderBlueprint")
public interface Order
extends OrderBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Order instance) {
        return (Builder)Order.builder().from(instance);
    }

    public static Order create() {
        return Order.builder().buildPrototype();
    }

    public static Order create(String property) {
        return OrderSupport.create(property);
    }

    public static Order create(String property, OrderDirection direction) {
        return OrderSupport.create(property, direction);
    }

    public static Order create(String property, OrderDirection direction, boolean caseSensitive) {
        return OrderSupport.create(property, direction, caseSensitive);
    }

    @Override
    public String property();

    @Override
    public OrderDirection direction();

    @Override
    public boolean caseSensitive();

    public static class Builder
    extends BuilderBase<Builder, Order>
    implements io.helidon.common.Builder<Builder, Order> {
        private Builder() {
        }

        public Order buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OrderImpl(this);
        }

        public Order build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Order>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean caseSensitive = true;
        private OrderDirection direction = OrderDirection.ASC;
        private String property;

        protected BuilderBase() {
        }

        public BUILDER from(Order prototype) {
            this.property(prototype.property());
            this.direction(prototype.direction());
            this.caseSensitive(prototype.caseSensitive());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.property().ifPresent(this::property);
            this.direction(builder.direction());
            this.caseSensitive(builder.caseSensitive());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER property(String property) {
            Objects.requireNonNull(property);
            this.property = property;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER direction(OrderDirection direction) {
            Objects.requireNonNull(direction);
            this.direction = direction;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> property() {
            return Optional.ofNullable(this.property);
        }

        public OrderDirection direction() {
            return this.direction;
        }

        public boolean caseSensitive() {
            return this.caseSensitive;
        }

        public String toString() {
            return "OrderBuilder{property=" + this.property + ",direction=" + String.valueOf((Object)this.direction) + ",caseSensitive=" + this.caseSensitive + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.property == null) {
                collector.fatal(this.getClass(), "Property \"property\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class OrderImpl
        implements Order {
            private final boolean caseSensitive;
            private final OrderDirection direction;
            private final String property;

            protected OrderImpl(BuilderBase<?, ?> builder) {
                this.property = builder.property().get();
                this.direction = builder.direction();
                this.caseSensitive = builder.caseSensitive();
            }

            @Override
            public String property() {
                return this.property;
            }

            @Override
            public OrderDirection direction() {
                return this.direction;
            }

            @Override
            public boolean caseSensitive() {
                return this.caseSensitive;
            }

            public String toString() {
                return "Order{property=" + this.property + ",direction=" + String.valueOf((Object)this.direction) + ",caseSensitive=" + this.caseSensitive + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Order)) {
                    return false;
                }
                Order other = (Order)o;
                return Objects.equals(this.property, other.property()) && Objects.equals((Object)this.direction, (Object)other.direction()) && this.caseSensitive == other.caseSensitive();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.property, this.direction, this.caseSensitive});
            }
        }
    }
}

