/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.data.PageRequestBlueprint;
import io.helidon.data.PageRequestSupport;
import java.util.Objects;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.PageRequestBlueprint")
public interface PageRequest
extends PageRequestBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PageRequest instance) {
        return (Builder)PageRequest.builder().from(instance);
    }

    public static PageRequest create() {
        return PageRequest.builder().buildPrototype();
    }

    public static PageRequest create(int page, int size) {
        return PageRequestSupport.create(page, size);
    }

    public static PageRequest create(int page) {
        return PageRequestSupport.create(page);
    }

    public int offset();

    @Override
    public int page();

    @Override
    public int size();

    public static class Builder
    extends BuilderBase<Builder, PageRequest>
    implements io.helidon.common.Builder<Builder, PageRequest> {
        private Builder() {
        }

        public PageRequest buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.PageRequestImpl(this);
        }

        public PageRequest build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends PageRequest>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private int page;
        private int size;

        protected BuilderBase() {
        }

        public BUILDER from(PageRequest prototype) {
            this.page(prototype.page());
            this.size(prototype.size());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.page(builder.page());
            this.size(builder.size());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER page(int page) {
            this.page = page;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER size(int size) {
            this.size = size;
            return (BUILDER)((BuilderBase)this.self());
        }

        public int page() {
            return this.page;
        }

        public int size() {
            return this.size;
        }

        public String toString() {
            return "PageRequestBuilder{page=" + this.page + ",size=" + this.size + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class PageRequestImpl
        implements PageRequest {
            private final int page;
            private final int size;

            protected PageRequestImpl(BuilderBase<?, ?> builder) {
                this.page = builder.page();
                this.size = builder.size();
            }

            @Override
            public int offset() {
                return PageRequestSupport.offset(this);
            }

            @Override
            public int page() {
                return this.page;
            }

            @Override
            public int size() {
                return this.size;
            }

            public String toString() {
                return "PageRequest{page=" + this.page + ",size=" + this.size + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PageRequest)) {
                    return false;
                }
                PageRequest other = (PageRequest)o;
                return this.page == other.page() && this.size == other.size();
            }

            public int hashCode() {
                return Objects.hash(this.page, this.size);
            }
        }
    }
}

