/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.data.codegen.BaseQueryMethodsGenerator;
import io.helidon.data.codegen.DataCodegenTypes;
import io.helidon.data.codegen.common.BaseRepositoryInterfaceGenerator;
import io.helidon.data.codegen.common.MethodParams;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.parser.MethodNameParser;
import io.helidon.data.codegen.query.DataQuery;
import io.helidon.data.codegen.query.ProjectionExpression;
import io.helidon.data.codegen.query.ProjectionResult;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class QueryByNameMethodsGenerator
extends BaseQueryMethodsGenerator {
    private static final Map<TypeName, Generator> NUMBER_RESULT_GENERATORS;
    private static final Map<TypeName, Generator> BOOLEAN_RESULT_GENERATORS;
    private static final Map<TypeName, Generator> DML_GENERATORS;
    private static final Map<TypeName, DynamicGenerator> DYNAMIC_NUMBER_RESULT_GENERATORS;
    private static final Map<TypeName, DynamicGenerator> DYNAMIC_BOOLEAN_RESULT_GENERATORS;
    private static final Map<TypeName, DynamicGenerator> DYNAMIC_DML_GENERATORS;
    private final MethodNameParser parser = MethodNameParser.create();
    private final List<TypedElementInfo> methods;

    private QueryByNameMethodsGenerator(RepositoryInfo repositoryInfo, List<TypedElementInfo> methods, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        super(repositoryInfo, classModel, codegenContext, persistenceGenerator);
        this.methods = methods;
    }

    static void generate(RepositoryInfo repositoryInfo, List<TypedElementInfo> methods, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        QueryByNameMethodsGenerator generator = new QueryByNameMethodsGenerator(repositoryInfo, methods, classModel, codegenContext, persistenceGenerator);
        generator.generate();
    }

    public void generate() {
        this.methods.forEach(this::addGeneratedMethod);
    }

    private static void generateQueryItem(Method.Builder builder, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query, TypeName resultType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteQueryItem(b2, query, resultType), (String)"executor"));
    }

    private static void generateDynamicQueryItem(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName resultType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, resultType), (String)"executor"));
    }

    private static void generateQueryOptional(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.optionalFromQuery((Method.Builder)b1, b2 -> QueryByNameMethodsGenerator.call((Method.Builder)b2, b3 -> statementGenerator.addExecuteQueryList(b3, query, QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo)), (String)"executor"), (TypeName)statementGenerator.executorType()));
    }

    private static void generateDynamicQueryOptional(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.optionalFromQuery((Method.Builder)b1, b2 -> QueryByNameMethodsGenerator.call((Method.Builder)b2, b3 -> statementGenerator.addExecuteDynamicQueryList(b3, repositoryInfo, methodInfo, methodParams, dataQuery, QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo)), (String)"executor"), (TypeName)statementGenerator.executorType()));
    }

    private static void generateQueryList(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteQueryList(b2, query, QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo)), (String)"executor"));
    }

    private static void generateDynamicQueryList(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryList(b2, repositoryInfo, methodInfo, methodParams, dataQuery, QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo)), (String)"executor"));
    }

    private static void generateQueryStream(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteQueryStream(b2, query, QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo)), (String)"executor"));
    }

    private static void generateDynamicQueryStream(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryStream(b2, repositoryInfo, methodInfo, methodParams, dataQuery, QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo)), (String)"executor"));
    }

    private static void generateQuerySlice(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query, MethodParams methodParams) {
        TypedElementInfo pageRequest = QueryByNameMethodsGenerator.pageRequestRequired(methodParams, methodInfo);
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addSessionLambda(b2, b3 -> {
            ((Method.Builder)b3.addContent(DataCodegenTypes.SLICE)).addContentLine(".create(");
            QueryByNameMethodsGenerator.increasePadding((Method.Builder)b3, (int)2);
            ((Method.Builder)b3.addContent(pageRequest.elementName())).addContentLine(",");
            statementGenerator.addQueryPage(b3, query, QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo), pageRequest.elementName() + ".offset()", pageRequest.elementName() + ".size()");
            b3.addContent(")");
            QueryByNameMethodsGenerator.decreasePadding((Method.Builder)b3, (int)2);
        }), (String)"executor"));
    }

    private static void generateDynamicQuerySlice(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery) {
        TypedElementInfo pageRequest = QueryByNameMethodsGenerator.pageRequestRequired(methodParams, methodInfo);
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addSessionLambdaBlock(b2, b3 -> {
            List settings = statementGenerator.addDynamicSliceQuery(builder, repositoryInfo, methodInfo, methodParams, dataQuery, "stmt", QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo));
            QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b4 -> {
                ((Method.Builder)b4.addContent(DataCodegenTypes.SLICE)).addContentLine(".create(");
                QueryByNameMethodsGenerator.increasePadding((Method.Builder)b4, (int)2);
                ((Method.Builder)b4.addContent(pageRequest.elementName())).addContentLine(",");
                statementGenerator.addQueryPage(b4, b5 -> QueryByNameMethodsGenerator.identifier((Method.Builder)b5, (String)"stmt"), settings, null, pageRequest.elementName() + ".offset()", pageRequest.elementName() + ".size()");
                b4.addContent(")");
                QueryByNameMethodsGenerator.decreasePadding((Method.Builder)b4, (int)2);
            });
        }), (String)"executor"));
    }

    private static void generateQueryPage(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query, DataQuery dataQuery, MethodParams methodParams, PersistenceGenerator.QueryBuilder queryBuilder) {
        TypedElementInfo pageRequest = QueryByNameMethodsGenerator.pageRequestRequired(methodParams, methodInfo);
        PersistenceGenerator.Query countQuery = queryBuilder.buildCountQuery(dataQuery, methodParams.parameters().stream().map(x$0 -> QueryByNameMethodsGenerator.paramElementName((TypedElementInfo)x$0)).collect(Collectors.toList()));
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addSessionLambda(b2, b3 -> {
            ((Method.Builder)b3.addContent(DataCodegenTypes.PAGE)).addContentLine(".create(");
            QueryByNameMethodsGenerator.increasePadding((Method.Builder)b3, (int)2);
            ((Method.Builder)b3.addContent(pageRequest.elementName())).addContentLine(",");
            statementGenerator.addQueryPage(b3, query, QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo), pageRequest.elementName() + ".offset()", pageRequest.elementName() + ".size()");
            b3.addContentLine(",");
            statementGenerator.addQueryItem(b3, countQuery, NUMBER);
            ((Method.Builder)((Method.Builder)b3.addContentLine("")).padContent(2)).addContent(".intValue()");
            b3.addContent(")");
            QueryByNameMethodsGenerator.decreasePadding((Method.Builder)b3, (int)2);
        }), (String)"executor"));
    }

    private static void generateDynamicQueryPage(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery) {
        TypedElementInfo pageRequest = QueryByNameMethodsGenerator.pageRequestRequired(methodParams, methodInfo);
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addSessionLambdaBlock(b2, b3 -> {
            List settings = statementGenerator.addDynamicPageQueries(builder, repositoryInfo, methodInfo, methodParams, dataQuery, "stmt", "countStmt", QueryByNameMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo));
            QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b4 -> {
                ((Method.Builder)b4.addContent(DataCodegenTypes.PAGE)).addContentLine(".create(");
                QueryByNameMethodsGenerator.increasePadding((Method.Builder)b4, (int)2);
                ((Method.Builder)b4.addContent(pageRequest.elementName())).addContentLine(",");
                statementGenerator.addQueryPage(b4, b5 -> QueryByNameMethodsGenerator.identifier((Method.Builder)b5, (String)"stmt"), settings, null, pageRequest.elementName() + ".offset()", pageRequest.elementName() + ".size()");
                b4.addContentLine(",");
                statementGenerator.addQueryCount(builder, b5 -> QueryByNameMethodsGenerator.identifier((Method.Builder)b5, (String)"countStmt"), settings, null);
                b4.addContent(")");
                QueryByNameMethodsGenerator.decreasePadding((Method.Builder)b4, (int)2);
            });
        }), (String)"executor"));
    }

    private static void generateNumber(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.generateQueryItem(builder, statementGenerator, query, NUMBER);
    }

    private static void generateLong(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> {
            statementGenerator.addExecuteQueryItem(b2, query, NUMBER);
            b2.addContent(".longValue()");
        }, (String)"executor"));
    }

    private static void generateInt(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> {
            statementGenerator.addExecuteQueryItem(b2, query, NUMBER);
            b2.addContent(".intValue()");
        }, (String)"executor"));
    }

    private static void generateShort(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> {
            statementGenerator.addExecuteQueryItem(b2, query, NUMBER);
            b2.addContent(".shortValue()");
        }, (String)"executor"));
    }

    private static void generateByte(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> {
            statementGenerator.addExecuteQueryItem(b2, query, NUMBER);
            b2.addContent(".byteValue()");
        }, (String)"executor"));
    }

    private static void generateFloat(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> {
            statementGenerator.addExecuteQueryItem(b2, query, NUMBER);
            b2.addContent(".floatValue()");
        }, (String)"executor"));
    }

    private static void generateDouble(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> {
            statementGenerator.addExecuteQueryItem(b2, query, NUMBER);
            b2.addContent(".doubleValue()");
        }, (String)"executor"));
    }

    private static void generateBigInteger(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)b1.addContent(BigInteger.class)).addContent(".valueOf(");
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> {
                statementGenerator.addExecuteQueryItem(b2, query, NUMBER);
                b2.addContent(".longValue()");
            }, (String)"executor");
            b1.addContent(")");
        });
    }

    private static void generateBigDecimal(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)b1.addContent(statementGenerator.executorType())).addContent(".createBigDecimal(");
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteQueryItem(b2, query, NUMBER), (String)"executor");
            b1.addContent(")");
        });
    }

    private static void generateBoolean(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteQueryItem(b2, query, NUMBER), (String)"executor");
            b1.addContent(".longValue() > 0");
        });
    }

    private static void generateDynamicNumber(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.generateDynamicQueryItem(builder, repositoryInfo, methodInfo, statementGenerator, methodParams, dataQuery, NUMBER);
    }

    private static void generateDynamicLong(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, NUMBER), (String)"executor");
            b1.addContent(".longValue()");
        });
    }

    private static void generateDynamicInt(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, NUMBER), (String)"executor");
            b1.addContent(".intValue()");
        });
    }

    private static void generateDynamicShort(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, NUMBER), (String)"executor");
            b1.addContent(".shortValue()");
        });
    }

    private static void generateDynamicByte(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, NUMBER), (String)"executor");
            b1.addContent(".byteValue()");
        });
    }

    private static void generateDynamicFloat(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, NUMBER), (String)"executor");
            b1.addContent(".floatValue()");
        });
    }

    private static void generateDynamicDouble(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, NUMBER), (String)"executor");
            b1.addContent(".doubleValue()");
        });
    }

    private static void generateDynamicBigInteger(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)b1.addContent(BigInteger.class)).addContent(".valueOf(");
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, NUMBER), (String)"executor");
            b1.addContent(".longValue())");
        });
    }

    private static void generateDynamicBigDecimal(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)b1.addContent(statementGenerator.executorType())).addContent(".createBigDecimal(");
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, NUMBER), (String)"executor");
            b1.addContent(")");
        });
    }

    private static void generateDynamicBoolean(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDynamicQueryItem(b2, repositoryInfo, methodInfo, methodParams, dataQuery, NUMBER), (String)"executor");
            b1.addContent(".longValue() > 0");
        });
    }

    private static void generateDmlVoid(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.statement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.run((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor"));
    }

    private static void generateDmlBoxedVoid(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.statement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.run((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor"));
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, x$0 -> BaseRepositoryInterfaceGenerator.nullValue((Method.Builder)x$0));
    }

    private static void generateDmlBoolean(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor");
            b1.addContent(" > 0");
        });
    }

    private static void generateDmlLong(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".longValue()");
        });
    }

    private static void generateDmlInt(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".intValue()");
        });
    }

    private static void generateDmlShort(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".shortValue()");
        });
    }

    private static void generateDmlByte(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".byteValue()");
        });
    }

    private static void generateDmlFloat(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".floatValue()");
        });
    }

    private static void generateDmlDouble(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".doubleValue()");
        });
    }

    private static void generateDmlBigInteger(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)b1.addContent(BigInteger.class)).addContent(".valueOf(");
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".longValue())");
        });
    }

    private static void generateDmlBigDecimal(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)b1.addContent(BigDecimal.class)).addContent(".valueOf(");
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteDml(b2, query), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".longValue())");
        });
    }

    private static void generateDynamicDmlVoid(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.statement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.run((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor"));
    }

    private static void generateDynamicDmlBoxedVoid(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.statement((Method.Builder)builder, b1 -> QueryByNameMethodsGenerator.run((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor"));
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, x$0 -> BaseRepositoryInterfaceGenerator.nullValue((Method.Builder)x$0));
    }

    private static void generateDynamicDmlBoolean(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor");
            b1.addContent(" > 0");
        });
    }

    private static void generateDynamicDmlLong(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".longValue()");
        });
    }

    private static void generateDynamicDmlInt(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".intValue()");
        });
    }

    private static void generateDynamicDmlShort(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".shortValue()");
        });
    }

    private static void generateDynamicDmlByte(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".byteValue()");
        });
    }

    private static void generateDynamicDmlFloat(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".floatValue()");
        });
    }

    private static void generateDynamicDmlDouble(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".doubleValue()");
        });
    }

    private static void generateDynamicDmlBigInteger(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)b1.addContent(BigInteger.class)).addContent(".valueOf(");
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".longValue())");
        });
    }

    private static void generateDynamicDmlBigDecimal(Method.Builder builder, RepositoryInfo repositoryInfo, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        QueryByNameMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> {
            ((Method.Builder)b1.addContent(BigDecimal.class)).addContent(".valueOf(");
            QueryByNameMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addDynamicDml(b2, repositoryInfo, methodInfo, methodParams, dataQuery, returnType), (String)"executor");
            ((Method.Builder)((Method.Builder)b1.addContentLine("")).padContent(2)).addContent(".longValue())");
        });
    }

    private void addGeneratedMethod(TypedElementInfo methodInfo) {
        if (this.parser.parse(methodInfo.elementName())) {
            try {
                this.classModel().addMethod(builder -> this.generateMethod((Method.Builder)builder, methodInfo));
            }
            catch (Exception e) {
                String message = e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : "Code generation of query by method name method failed";
                throw new CodegenException(message, (Throwable)e, (Object)methodInfo.originatingElement());
            }
        } else {
            this.methodWarning(methodInfo, "Skipping unsupported method name");
        }
    }

    private void generateMethod(Method.Builder builder, TypedElementInfo methodInfo) {
        block7: {
            DataQuery dataQuery;
            MethodParams methodParams;
            block6: {
                methodParams = this.generateHeader(builder, methodInfo);
                dataQuery = this.parser.dataQuery();
                this.validateResult(dataQuery, methodInfo);
                this.codegenContext().logger().log(System.Logger.Level.TRACE, String.format("QbMN method %s", methodInfo.elementName()));
                if (!methodParams.dynamic()) break block6;
                switch (dataQuery.projection().action()) {
                    case Select: {
                        this.generateDynamicQuery(builder, methodInfo, dataQuery, methodParams);
                        break block7;
                    }
                    case Delete: 
                    case Update: {
                        throw new UnsupportedOperationException("Sort parameter used in DML statement");
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown query action " + String.valueOf(dataQuery.projection().action()));
                    }
                }
            }
            PersistenceGenerator.Query query = this.queryBuilder().buildQuery(dataQuery, methodParams.parameters().stream().map(x$0 -> QueryByNameMethodsGenerator.paramElementName((TypedElementInfo)x$0)).collect(Collectors.toList()));
            if (query.isDml()) {
                this.generateDml(builder, methodInfo, query);
            } else {
                this.generateQuery(builder, methodInfo, query, dataQuery, methodParams);
            }
        }
    }

    private void generateDml(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.Query query) {
        TypeName returnType = methodInfo.typeName();
        if (!DML_GENERATORS.containsKey(returnType)) {
            throw new UnsupportedOperationException("Unsupported method " + methodInfo.elementName() + " return type " + String.valueOf(returnType));
        }
        DML_GENERATORS.get(returnType).generate(builder, methodInfo, this.statementGenerator(), query);
    }

    private void generateDynamicDml(Method.Builder builder, TypedElementInfo methodInfo, DataQuery dataQuery, MethodParams methodParams) {
        TypeName returnType = methodInfo.typeName();
        if (!DYNAMIC_DML_GENERATORS.containsKey(returnType)) {
            throw new UnsupportedOperationException("Unsupported method " + methodInfo.elementName() + " return type " + String.valueOf(returnType));
        }
        DYNAMIC_DML_GENERATORS.get(returnType).generate(builder, this.repositoryInfo(), methodInfo, this.statementGenerator(), methodParams, dataQuery, returnType);
    }

    private void generateQuery(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.Query query, DataQuery dataQuery, MethodParams methodParams) {
        switch (query.returnType()) {
            case ENTITY: {
                this.generateEntityQuery(builder, methodInfo, query, dataQuery, methodParams);
                break;
            }
            case NUMBER: {
                this.generateQuery(builder, methodInfo, query, NUMBER_RESULT_GENERATORS);
                break;
            }
            case BOOLEAN: {
                this.generateQuery(builder, methodInfo, query, BOOLEAN_RESULT_GENERATORS);
                break;
            }
            case DML: {
                throw new UnsupportedOperationException("Query return type " + String.valueOf(query.returnType()) + " is not supported for SELECT statement");
            }
            default: {
                throw new UnsupportedOperationException("Unsupported query return type " + String.valueOf(query.returnType()));
            }
        }
    }

    private void generateDynamicQuery(Method.Builder builder, TypedElementInfo methodInfo, DataQuery dataQuery, MethodParams methodParams) {
        PersistenceGenerator.QueryReturnType returnType = this.queryBuilder().queryReturntype(dataQuery);
        switch (returnType) {
            case ENTITY: {
                this.generateEntityDynamicQuery(builder, methodInfo, dataQuery, methodParams);
                break;
            }
            case NUMBER: {
                this.generateDynamicQuery(builder, methodInfo, dataQuery, methodParams, DYNAMIC_NUMBER_RESULT_GENERATORS);
                break;
            }
            case BOOLEAN: {
                this.generateDynamicQuery(builder, methodInfo, dataQuery, methodParams, DYNAMIC_BOOLEAN_RESULT_GENERATORS);
                break;
            }
            case DML: {
                throw new UnsupportedOperationException("Query return type " + String.valueOf(returnType) + " is not supported for SELECT statement");
            }
            default: {
                throw new UnsupportedOperationException("Unsupported query return type " + String.valueOf(returnType));
            }
        }
    }

    private void generateQuery(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.Query query, Map<TypeName, Generator> generators) {
        TypeName returnType = methodInfo.typeName();
        if (!generators.containsKey(returnType)) {
            throw new UnsupportedOperationException("Unsupported return type " + String.valueOf(returnType) + " of method " + methodInfo.elementName());
        }
        generators.get(returnType).generate(builder, methodInfo, this.statementGenerator(), query);
    }

    private void generateDynamicQuery(Method.Builder builder, TypedElementInfo methodInfo, DataQuery dataQuery, MethodParams methodParams, Map<TypeName, DynamicGenerator> generators) {
        TypeName returnType = methodInfo.typeName();
        if (!generators.containsKey(returnType)) {
            throw new UnsupportedOperationException("Unsupported return type " + String.valueOf(returnType) + " of method " + methodInfo.elementName());
        }
        generators.get(returnType).generate(builder, this.repositoryInfo(), methodInfo, this.statementGenerator(), methodParams, dataQuery, returnType);
    }

    private void generateEntityQuery(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.Query query, DataQuery dataQuery, MethodParams methodParams) {
        if (QueryByNameMethodsGenerator.isStream((TypeName)methodInfo.typeName())) {
            QueryByNameMethodsGenerator.generateQueryStream(builder, methodInfo, this.statementGenerator(), query);
        } else if (QueryByNameMethodsGenerator.isListOrCollection((TypeName)methodInfo.typeName())) {
            QueryByNameMethodsGenerator.generateQueryList(builder, methodInfo, this.statementGenerator(), query);
        } else if (methodInfo.typeName().isOptional()) {
            QueryByNameMethodsGenerator.generateQueryOptional(builder, methodInfo, this.statementGenerator(), query);
        } else if (DataCodegenTypes.SLICE.equals((Object)methodInfo.typeName())) {
            QueryByNameMethodsGenerator.generateQuerySlice(builder, methodInfo, this.statementGenerator(), query, methodParams);
        } else if (DataCodegenTypes.PAGE.equals((Object)methodInfo.typeName())) {
            QueryByNameMethodsGenerator.generateQueryPage(builder, methodInfo, this.statementGenerator(), query, dataQuery, methodParams, this.queryBuilder());
        } else {
            QueryByNameMethodsGenerator.generateQueryItem(builder, this.statementGenerator(), query, methodInfo.typeName());
        }
    }

    private void generateEntityDynamicQuery(Method.Builder builder, TypedElementInfo methodInfo, DataQuery dataQuery, MethodParams methodParams) {
        if (QueryByNameMethodsGenerator.isStream((TypeName)methodInfo.typeName())) {
            QueryByNameMethodsGenerator.generateDynamicQueryStream(builder, this.repositoryInfo(), methodInfo, this.statementGenerator(), methodParams, dataQuery);
        } else if (QueryByNameMethodsGenerator.isListOrCollection((TypeName)methodInfo.typeName())) {
            QueryByNameMethodsGenerator.generateDynamicQueryList(builder, this.repositoryInfo(), methodInfo, this.statementGenerator(), methodParams, dataQuery);
        } else if (methodInfo.typeName().isOptional()) {
            QueryByNameMethodsGenerator.generateDynamicQueryOptional(builder, this.repositoryInfo(), methodInfo, this.statementGenerator(), methodParams, dataQuery);
        } else if (DataCodegenTypes.SLICE.equals((Object)methodInfo.typeName())) {
            QueryByNameMethodsGenerator.generateDynamicQuerySlice(builder, this.repositoryInfo(), methodInfo, this.statementGenerator(), methodParams, dataQuery);
        } else if (DataCodegenTypes.PAGE.equals((Object)methodInfo.typeName())) {
            QueryByNameMethodsGenerator.generateDynamicQueryPage(builder, this.repositoryInfo(), methodInfo, this.statementGenerator(), methodParams, dataQuery);
        } else {
            QueryByNameMethodsGenerator.generateDynamicQueryItem(builder, this.repositoryInfo(), methodInfo, this.statementGenerator(), methodParams, dataQuery, methodInfo.typeName());
        }
    }

    private void validateResult(DataQuery dataQuery, TypedElementInfo methodInfo) {
        dataQuery.projection().result().ifPresentOrElse(result -> this.validateProjectionResult(dataQuery, methodInfo, (ProjectionResult)result), () -> {
            throw new IllegalArgumentException(String.format("Method %s: missing projection result in DataQuery instance", QueryByNameMethodsGenerator.methodNameForException(methodInfo)));
        });
        switch (dataQuery.projection().action()) {
            case Select: {
                dataQuery.projection().expression().ifPresent(expression -> this.validateProjectionExpression(dataQuery, methodInfo, (ProjectionExpression)expression));
                break;
            }
        }
    }

    private void validateProjectionResult(DataQuery dataQuery, TypedElementInfo methodInfo, ProjectionResult result) {
        TypeName returnType = methodInfo.typeName();
        switch (result) {
            case Exists: {
                if (BOOLEAN_RESULT_GENERATORS.containsKey(returnType)) break;
                throw new IllegalArgumentException(String.format("Method %s with exists prefix requires boolean return type, but %s was found", QueryByNameMethodsGenerator.methodNameForException(methodInfo), returnType));
            }
            case Count: {
                if (NUMBER_RESULT_GENERATORS.containsKey(returnType)) break;
                throw new IllegalArgumentException(String.format("Method %s with count prefix requires numeric return type, but %s was found", QueryByNameMethodsGenerator.methodNameForException(methodInfo), returnType));
            }
            case Get: {
                if (!returnType.isOptional()) break;
                throw new IllegalArgumentException(String.format("Method %s with get prefix does not allow Optional as return type, but %s was found", QueryByNameMethodsGenerator.methodNameForException(methodInfo), returnType));
            }
            case Find: {
                if (returnType.isOptional() || QueryByNameMethodsGenerator.isListOrCollection((TypeName)methodInfo.typeName()) || QueryByNameMethodsGenerator.isStream((TypeName)methodInfo.typeName())) break;
                throw new IllegalArgumentException(String.format("Method %s with find prefix requires Optional return type, but %s was found", QueryByNameMethodsGenerator.methodNameForException(methodInfo), returnType));
            }
            case List: {
                if (QueryByNameMethodsGenerator.isListOrCollection((TypeName)methodInfo.typeName()) || QueryByNameMethodsGenerator.isSliceOrPage((TypeName)methodInfo.typeName())) break;
                throw new IllegalArgumentException(String.format("Method %s with list prefix requires Collection or List return type, but %s was found", QueryByNameMethodsGenerator.methodNameForException(methodInfo), returnType));
            }
            case Stream: {
                if (QueryByNameMethodsGenerator.isStream((TypeName)methodInfo.typeName())) break;
                throw new IllegalArgumentException(String.format("Method %s with stream prefix requires Collection or List return type, but %s was found", QueryByNameMethodsGenerator.methodNameForException(methodInfo), returnType));
            }
            case Dml: {
                if (DML_GENERATORS.containsKey(returnType)) break;
                throw new IllegalArgumentException(String.format("Method %s with update or delete prefix requires void, boolean or numeric return type, but %s was found", QueryByNameMethodsGenerator.methodNameForException(methodInfo), returnType));
            }
        }
    }

    private void validateProjectionExpression(DataQuery dataQuery, TypedElementInfo methodInfo, ProjectionExpression expression) {
        TypeName returnType = methodInfo.typeName();
        switch (expression.operator()) {
            case Avg: {
                if (returnType.equals((Object)TypeNames.PRIMITIVE_DOUBLE) || returnType.equals((Object)TypeNames.BOXED_DOUBLE) || returnType.equals((Object)TypeNames.PRIMITIVE_FLOAT) || returnType.equals((Object)TypeNames.BOXED_FLOAT)) break;
                throw new IllegalArgumentException(String.format("Method %s projection operator Avg requires method return type float or double", QueryByNameMethodsGenerator.methodNameForException(methodInfo)));
            }
        }
    }

    private static String methodNameForException(TypedElementInfo methodInfo) {
        StringBuilder sb = new StringBuilder();
        methodInfo.enclosingType().ifPresent(t -> sb.append(t.className()).append("::"));
        sb.append(methodInfo.elementName());
        return sb.toString();
    }

    static {
        HashMap<TypeName, Object> generators = new HashMap<TypeName, Object>();
        generators.put(NUMBER, QueryByNameMethodsGenerator::generateNumber);
        generators.put(TypeNames.PRIMITIVE_LONG, QueryByNameMethodsGenerator::generateLong);
        generators.put(TypeNames.BOXED_LONG, QueryByNameMethodsGenerator::generateLong);
        generators.put(TypeNames.PRIMITIVE_INT, QueryByNameMethodsGenerator::generateInt);
        generators.put(TypeNames.BOXED_INT, QueryByNameMethodsGenerator::generateInt);
        generators.put(TypeNames.PRIMITIVE_SHORT, QueryByNameMethodsGenerator::generateShort);
        generators.put(TypeNames.BOXED_SHORT, QueryByNameMethodsGenerator::generateShort);
        generators.put(TypeNames.PRIMITIVE_BYTE, QueryByNameMethodsGenerator::generateByte);
        generators.put(TypeNames.BOXED_BYTE, QueryByNameMethodsGenerator::generateByte);
        generators.put(TypeNames.PRIMITIVE_FLOAT, QueryByNameMethodsGenerator::generateFloat);
        generators.put(TypeNames.BOXED_FLOAT, QueryByNameMethodsGenerator::generateFloat);
        generators.put(TypeNames.PRIMITIVE_DOUBLE, QueryByNameMethodsGenerator::generateDouble);
        generators.put(TypeNames.BOXED_DOUBLE, QueryByNameMethodsGenerator::generateDouble);
        generators.put(BIG_INTEGER, QueryByNameMethodsGenerator::generateBigInteger);
        generators.put(BIG_DECIMAL, QueryByNameMethodsGenerator::generateBigDecimal);
        NUMBER_RESULT_GENERATORS = Map.copyOf(generators);
        generators = new HashMap();
        generators.put(TypeNames.PRIMITIVE_BOOLEAN, QueryByNameMethodsGenerator::generateBoolean);
        generators.put(TypeNames.BOXED_BOOLEAN, QueryByNameMethodsGenerator::generateBoolean);
        BOOLEAN_RESULT_GENERATORS = Map.copyOf(generators);
        generators = new HashMap();
        generators.put(TypeNames.PRIMITIVE_VOID, QueryByNameMethodsGenerator::generateDmlVoid);
        generators.put(TypeNames.BOXED_VOID, QueryByNameMethodsGenerator::generateDmlBoxedVoid);
        generators.put(TypeNames.PRIMITIVE_BOOLEAN, QueryByNameMethodsGenerator::generateDmlBoolean);
        generators.put(TypeNames.BOXED_BOOLEAN, QueryByNameMethodsGenerator::generateDmlBoolean);
        generators.put(TypeNames.PRIMITIVE_LONG, QueryByNameMethodsGenerator::generateDmlLong);
        generators.put(TypeNames.BOXED_LONG, QueryByNameMethodsGenerator::generateDmlLong);
        generators.put(TypeNames.PRIMITIVE_INT, QueryByNameMethodsGenerator::generateDmlInt);
        generators.put(TypeNames.BOXED_INT, QueryByNameMethodsGenerator::generateDmlInt);
        generators.put(TypeNames.PRIMITIVE_SHORT, QueryByNameMethodsGenerator::generateDmlShort);
        generators.put(TypeNames.BOXED_SHORT, QueryByNameMethodsGenerator::generateDmlShort);
        generators.put(TypeNames.PRIMITIVE_BYTE, QueryByNameMethodsGenerator::generateDmlByte);
        generators.put(TypeNames.BOXED_BYTE, QueryByNameMethodsGenerator::generateDmlByte);
        generators.put(TypeNames.PRIMITIVE_FLOAT, QueryByNameMethodsGenerator::generateDmlFloat);
        generators.put(TypeNames.BOXED_FLOAT, QueryByNameMethodsGenerator::generateDmlFloat);
        generators.put(TypeNames.PRIMITIVE_DOUBLE, QueryByNameMethodsGenerator::generateDmlDouble);
        generators.put(TypeNames.BOXED_DOUBLE, QueryByNameMethodsGenerator::generateDmlDouble);
        generators.put(BIG_INTEGER, QueryByNameMethodsGenerator::generateDmlBigInteger);
        generators.put(BIG_DECIMAL, QueryByNameMethodsGenerator::generateDmlBigDecimal);
        DML_GENERATORS = Map.copyOf(generators);
        generators = new HashMap();
        generators.put(NUMBER, QueryByNameMethodsGenerator::generateDynamicNumber);
        generators.put(TypeNames.PRIMITIVE_LONG, QueryByNameMethodsGenerator::generateDynamicLong);
        generators.put(TypeNames.BOXED_LONG, QueryByNameMethodsGenerator::generateDynamicLong);
        generators.put(TypeNames.PRIMITIVE_INT, QueryByNameMethodsGenerator::generateDynamicInt);
        generators.put(TypeNames.BOXED_INT, QueryByNameMethodsGenerator::generateDynamicInt);
        generators.put(TypeNames.PRIMITIVE_SHORT, QueryByNameMethodsGenerator::generateDynamicShort);
        generators.put(TypeNames.BOXED_SHORT, QueryByNameMethodsGenerator::generateDynamicShort);
        generators.put(TypeNames.PRIMITIVE_BYTE, QueryByNameMethodsGenerator::generateDynamicByte);
        generators.put(TypeNames.BOXED_BYTE, QueryByNameMethodsGenerator::generateDynamicByte);
        generators.put(TypeNames.PRIMITIVE_FLOAT, QueryByNameMethodsGenerator::generateDynamicFloat);
        generators.put(TypeNames.BOXED_FLOAT, QueryByNameMethodsGenerator::generateDynamicFloat);
        generators.put(TypeNames.PRIMITIVE_DOUBLE, QueryByNameMethodsGenerator::generateDynamicDouble);
        generators.put(TypeNames.BOXED_DOUBLE, QueryByNameMethodsGenerator::generateDynamicDouble);
        generators.put(BIG_INTEGER, QueryByNameMethodsGenerator::generateDynamicBigInteger);
        generators.put(BIG_DECIMAL, QueryByNameMethodsGenerator::generateDynamicBigDecimal);
        DYNAMIC_NUMBER_RESULT_GENERATORS = Map.copyOf(generators);
        generators = new HashMap();
        generators.put(TypeNames.PRIMITIVE_BOOLEAN, QueryByNameMethodsGenerator::generateDynamicBoolean);
        generators.put(TypeNames.BOXED_BOOLEAN, QueryByNameMethodsGenerator::generateDynamicBoolean);
        DYNAMIC_BOOLEAN_RESULT_GENERATORS = Map.copyOf(generators);
        generators = new HashMap();
        generators.put(TypeNames.PRIMITIVE_VOID, QueryByNameMethodsGenerator::generateDynamicDmlVoid);
        generators.put(TypeNames.BOXED_VOID, QueryByNameMethodsGenerator::generateDynamicDmlBoxedVoid);
        generators.put(TypeNames.PRIMITIVE_BOOLEAN, QueryByNameMethodsGenerator::generateDynamicDmlBoolean);
        generators.put(TypeNames.BOXED_BOOLEAN, QueryByNameMethodsGenerator::generateDynamicDmlBoolean);
        generators.put(TypeNames.PRIMITIVE_LONG, QueryByNameMethodsGenerator::generateDynamicDmlLong);
        generators.put(TypeNames.BOXED_LONG, QueryByNameMethodsGenerator::generateDynamicDmlLong);
        generators.put(TypeNames.PRIMITIVE_INT, QueryByNameMethodsGenerator::generateDynamicDmlInt);
        generators.put(TypeNames.BOXED_INT, QueryByNameMethodsGenerator::generateDynamicDmlInt);
        generators.put(TypeNames.PRIMITIVE_SHORT, QueryByNameMethodsGenerator::generateDynamicDmlShort);
        generators.put(TypeNames.BOXED_SHORT, QueryByNameMethodsGenerator::generateDynamicDmlShort);
        generators.put(TypeNames.PRIMITIVE_BYTE, QueryByNameMethodsGenerator::generateDynamicDmlByte);
        generators.put(TypeNames.BOXED_BYTE, QueryByNameMethodsGenerator::generateDynamicDmlByte);
        generators.put(TypeNames.PRIMITIVE_FLOAT, QueryByNameMethodsGenerator::generateDynamicDmlFloat);
        generators.put(TypeNames.BOXED_FLOAT, QueryByNameMethodsGenerator::generateDynamicDmlFloat);
        generators.put(TypeNames.PRIMITIVE_DOUBLE, QueryByNameMethodsGenerator::generateDynamicDmlDouble);
        generators.put(TypeNames.BOXED_DOUBLE, QueryByNameMethodsGenerator::generateDynamicDmlDouble);
        generators.put(BIG_INTEGER, QueryByNameMethodsGenerator::generateDynamicDmlBigInteger);
        generators.put(BIG_DECIMAL, QueryByNameMethodsGenerator::generateDynamicDmlBigDecimal);
        DYNAMIC_DML_GENERATORS = Map.copyOf(generators);
    }

    @FunctionalInterface
    private static interface Generator {
        public void generate(Method.Builder var1, TypedElementInfo var2, PersistenceGenerator.StatementGenerator var3, PersistenceGenerator.Query var4);
    }

    @FunctionalInterface
    private static interface DynamicGenerator {
        public void generate(Method.Builder var1, RepositoryInfo var2, TypedElementInfo var3, PersistenceGenerator.StatementGenerator var4, MethodParams var5, DataQuery var6, TypeName var7);
    }
}

