/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.query;

import java.util.Objects;
import java.util.Set;

public class QueryParameters {
    private final Type type;
    private final Set<Parameter> parameters;

    private QueryParameters(Type type, Set<Parameter> parameters) {
        this.type = type;
        this.parameters = parameters;
    }

    public static QueryParameters create(Type type, Set<Parameter> parameters) {
        return new QueryParameters(type, Set.copyOf(parameters));
    }

    public static Parameter ordinalParameter(int index) {
        return new OrdinalParameter(index);
    }

    public static Parameter namedParameter(String name) {
        return new NamedParameter(name);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public Type type() {
        return this.type;
    }

    public Set<Parameter> parameters() {
        return this.parameters;
    }

    public static enum Type {
        ORDINAL,
        NAMED;

    }

    private record OrdinalParameter(int index) implements Parameter
    {
        private OrdinalParameter {
            if (index < 0) {
                throw new IllegalArgumentException("Query parameter index is less than 0");
            }
        }

        @Override
        public String code() {
            return Integer.toString(this.index);
        }

        @Override
        public String name() {
            return Integer.toString(this.index);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof OrdinalParameter)) return false;
            OrdinalParameter parameter = (OrdinalParameter)other;
            if (this.index != parameter.index) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.index);
        }
    }

    private record NamedParameter(String name) implements Parameter
    {
        private NamedParameter {
            Objects.requireNonNull(name, "Query parameter name is null");
        }

        @Override
        public String code() {
            return new StringBuilder(this.name.length() + 2).append('\"').append(this.name).append('\"').toString();
        }

        @Override
        public int index() {
            throw new UnsupportedOperationException("Named query parameter does not have index");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof NamedParameter)) return false;
            NamedParameter parameter = (NamedParameter)other;
            if (!this.name.equals(parameter.name)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static interface Parameter {
        public String code();

        public String name();

        public int index();
    }
}

