/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.query;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.data.codegen.query.OrderExpressionBlueprint;
import io.helidon.data.codegen.query.OrderOperator;
import io.helidon.data.codegen.query.Property;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.codegen.query.OrderExpressionBlueprint")
public interface OrderExpression
extends OrderExpressionBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OrderExpression instance) {
        return (Builder)OrderExpression.builder().from(instance);
    }

    @Override
    public OrderOperator operator();

    @Override
    public Property property();

    public static class Builder
    extends BuilderBase<Builder, OrderExpression>
    implements io.helidon.common.Builder<Builder, OrderExpression> {
        private Builder() {
        }

        public OrderExpression buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OrderExpressionImpl(this);
        }

        public OrderExpression build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OrderExpression>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private OrderOperator operator = OrderOperator.ASC;
        private Property property;

        protected BuilderBase() {
        }

        public BUILDER from(OrderExpression prototype) {
            this.operator(prototype.operator());
            this.property(prototype.property());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.operator(builder.operator());
            builder.property().ifPresent(this::property);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER operator(OrderOperator operator) {
            Objects.requireNonNull(operator);
            this.operator = operator;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER property(Property property) {
            Objects.requireNonNull(property);
            this.property = property;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER property(Consumer<Property.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Property.Builder builder = Property.builder();
            consumer.accept(builder);
            this.property(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER property(Supplier<? extends Property> supplier) {
            Objects.requireNonNull(supplier);
            this.property(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public OrderOperator operator() {
            return this.operator;
        }

        public Optional<Property> property() {
            return Optional.ofNullable(this.property);
        }

        public String toString() {
            return "OrderExpressionBuilder{operator=" + String.valueOf((Object)this.operator) + ",property=" + String.valueOf(this.property) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.property == null) {
                collector.fatal(this.getClass(), "Property \"property\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class OrderExpressionImpl
        implements OrderExpression {
            private final OrderOperator operator;
            private final Property property;

            protected OrderExpressionImpl(BuilderBase<?, ?> builder) {
                this.operator = builder.operator();
                this.property = builder.property().get();
            }

            @Override
            public OrderOperator operator() {
                return this.operator;
            }

            @Override
            public Property property() {
                return this.property;
            }

            public String toString() {
                return "OrderExpression{operator=" + String.valueOf((Object)this.operator) + ",property=" + String.valueOf(this.property) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OrderExpression)) {
                    return false;
                }
                OrderExpression other = (OrderExpression)o;
                return Objects.equals((Object)this.operator, (Object)other.operator()) && Objects.equals(this.property, other.property());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.operator, this.property});
            }
        }
    }
}

