/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.query;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.data.codegen.query.CriteriaConditionBlueprint;
import io.helidon.data.codegen.query.CriteriaConditionSupport;
import io.helidon.data.codegen.query.CriteriaOperator;
import io.helidon.data.codegen.query.CriteriaParameters;
import io.helidon.data.codegen.query.Property;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.codegen.query.CriteriaConditionBlueprint")
public interface CriteriaCondition
extends CriteriaConditionBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CriteriaCondition instance) {
        return (Builder)CriteriaCondition.builder().from(instance);
    }

    public static CriteriaCondition createEqual(Property property, CharSequence parameter) {
        return CriteriaConditionSupport.createEqual(property, parameter);
    }

    public static CriteriaCondition createEqual(Property property) {
        return CriteriaConditionSupport.createEqual(property);
    }

    @Override
    public CriteriaOperator operator();

    @Override
    public Property property();

    @Override
    public Optional<CriteriaParameters> parameters();

    @Override
    public boolean not();

    @Override
    public boolean ignoreCase();

    public static class Builder
    extends BuilderBase<Builder, CriteriaCondition>
    implements io.helidon.common.Builder<Builder, CriteriaCondition> {
        private Builder() {
        }

        public CriteriaCondition buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.CriteriaConditionImpl(this);
        }

        public CriteriaCondition build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends CriteriaCondition>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean ignoreCase = false;
        private boolean not = false;
        private CriteriaOperator operator = CriteriaOperator.Equal;
        private CriteriaParameters parameters;
        private Property property;

        protected BuilderBase() {
        }

        public BUILDER from(CriteriaCondition prototype) {
            this.operator(prototype.operator());
            this.property(prototype.property());
            this.parameters(prototype.parameters());
            this.not(prototype.not());
            this.ignoreCase(prototype.ignoreCase());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.operator(builder.operator());
            builder.property().ifPresent(this::property);
            builder.parameters().ifPresent(this::parameters);
            this.not(builder.not());
            this.ignoreCase(builder.ignoreCase());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER operator(CriteriaOperator operator) {
            Objects.requireNonNull(operator);
            this.operator = operator;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER property(Property property) {
            Objects.requireNonNull(property);
            this.property = property;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER property(Consumer<Property.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Property.Builder builder = Property.builder();
            consumer.accept(builder);
            this.property(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER property(Supplier<? extends Property> supplier) {
            Objects.requireNonNull(supplier);
            this.property(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearParameters() {
            this.parameters = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parameters(CriteriaParameters parameters) {
            Objects.requireNonNull(parameters);
            this.parameters = parameters;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER not(boolean not) {
            this.not = not;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER ignoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public CriteriaOperator operator() {
            return this.operator;
        }

        public Optional<Property> property() {
            return Optional.ofNullable(this.property);
        }

        public Optional<CriteriaParameters> parameters() {
            return Optional.ofNullable(this.parameters);
        }

        public boolean not() {
            return this.not;
        }

        public boolean ignoreCase() {
            return this.ignoreCase;
        }

        public String toString() {
            return "CriteriaConditionBuilder{operator=" + String.valueOf((Object)this.operator) + ",property=" + String.valueOf(this.property) + ",parameters=" + String.valueOf(this.parameters) + ",not=" + this.not + ",ignoreCase=" + this.ignoreCase + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.property == null) {
                collector.fatal(this.getClass(), "Property \"property\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER parameters(Optional<? extends CriteriaParameters> parameters) {
            Objects.requireNonNull(parameters);
            this.parameters = parameters.map(CriteriaParameters.class::cast).orElse(this.parameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class CriteriaConditionImpl
        implements CriteriaCondition {
            private final boolean ignoreCase;
            private final boolean not;
            private final CriteriaOperator operator;
            private final Optional<CriteriaParameters> parameters;
            private final Property property;

            protected CriteriaConditionImpl(BuilderBase<?, ?> builder) {
                this.operator = builder.operator();
                this.property = builder.property().get();
                this.parameters = builder.parameters().map(Function.identity());
                this.not = builder.not();
                this.ignoreCase = builder.ignoreCase();
            }

            @Override
            public CriteriaOperator operator() {
                return this.operator;
            }

            @Override
            public Property property() {
                return this.property;
            }

            @Override
            public Optional<CriteriaParameters> parameters() {
                return this.parameters;
            }

            @Override
            public boolean not() {
                return this.not;
            }

            @Override
            public boolean ignoreCase() {
                return this.ignoreCase;
            }

            public String toString() {
                return "CriteriaCondition{operator=" + String.valueOf((Object)this.operator) + ",property=" + String.valueOf(this.property) + ",parameters=" + String.valueOf(this.parameters) + ",not=" + this.not + ",ignoreCase=" + this.ignoreCase + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CriteriaCondition)) {
                    return false;
                }
                CriteriaCondition other = (CriteriaCondition)o;
                return Objects.equals((Object)this.operator, (Object)other.operator()) && Objects.equals(this.property, other.property()) && Objects.equals(this.parameters, other.parameters()) && this.not == other.not() && this.ignoreCase == other.ignoreCase();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.operator, this.property, this.parameters, this.not, this.ignoreCase});
            }
        }
    }
}

