/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.query;

import io.helidon.data.codegen.query.CriteriaCondition;
import io.helidon.data.codegen.query.CriteriaConditionNext;
import io.helidon.data.codegen.query.LogicalOperator;
import java.util.ArrayList;
import java.util.List;

public class Criteria {
    private final CriteriaCondition firstExpression;
    private final List<CriteriaConditionNext> nextExpressions;

    private Criteria(CriteriaCondition firstExpression, List<CriteriaConditionNext> nextExpressions) {
        this.firstExpression = firstExpression;
        this.nextExpressions = nextExpressions;
    }

    public static Criteria create(CriteriaCondition condition) {
        return Criteria.builder().condition(condition).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public CriteriaCondition first() {
        return this.firstExpression;
    }

    public List<CriteriaConditionNext> next() {
        return this.nextExpressions;
    }

    public CriteriaConditionNext next(int index) {
        return this.nextExpressions.get(index);
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Criteria> {
        private final List<CriteriaConditionNext> nextExpressions = new ArrayList<CriteriaConditionNext>();
        private CriteriaCondition firstExpression = null;
        private LogicalOperator logicalOperator = null;

        private Builder() {
        }

        public Builder condition(CriteriaCondition condition) {
            if (this.firstExpression == null) {
                if (this.logicalOperator != null) {
                    throw new IllegalStateException("Logical operator " + String.valueOf((Object)this.logicalOperator) + " was set before first condition");
                }
                this.firstExpression = condition;
            } else {
                if (this.logicalOperator == null) {
                    throw new IllegalStateException("Logical operator was not set before 2nd and later condition");
                }
                this.nextExpressions.add(CriteriaConditionNext.create(this.logicalOperator, condition));
                this.logicalOperator = null;
            }
            return this;
        }

        public Builder and() {
            this.logicalOperator = LogicalOperator.AND;
            return this;
        }

        public Builder or() {
            this.logicalOperator = LogicalOperator.OR;
            return this;
        }

        public boolean isEmpty() {
            return this.firstExpression == null;
        }

        public Criteria build() {
            return new Criteria(this.firstExpression, this.nextExpressions);
        }
    }
}

