/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.parser;

import io.helidon.common.Builder;
import io.helidon.data.codegen.parser.ParserException;
import io.helidon.data.codegen.query.QueryParameters;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

class QueryParametersBuilder
implements Builder<QueryParametersBuilder, QueryParameters> {
    private final String statement;
    private final Set<QueryParameters.Parameter> parameters;
    private QueryParameters.Type type;

    private QueryParametersBuilder(String statement) {
        Objects.requireNonNull(statement);
        this.statement = statement;
        this.type = null;
        this.parameters = new HashSet<QueryParameters.Parameter>();
    }

    static QueryParametersBuilder create(String statement) {
        return new QueryParametersBuilder(statement);
    }

    public QueryParameters build() {
        return QueryParameters.create((QueryParameters.Type)this.type, Set.copyOf(this.parameters));
    }

    void ordinal(int index) {
        if (this.type == null) {
            this.type = QueryParameters.Type.ORDINAL;
        } else if (this.type == QueryParameters.Type.NAMED) {
            throw new ParserException("Cannot add ordinal parameter into named parameters list", this.statement);
        }
        this.parameters.add(QueryParameters.ordinalParameter((int)index));
    }

    void named(String name) {
        if (this.type == null) {
            this.type = QueryParameters.Type.NAMED;
        } else if (this.type == QueryParameters.Type.ORDINAL) {
            throw new ParserException("Cannot add named parameter into ordinal parameters list", this.statement);
        }
        this.parameters.add(QueryParameters.namedParameter((String)name));
    }
}

