/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.parser;

import io.helidon.data.codegen.parser.MethodName;
import io.helidon.data.codegen.parser.MethodNameParser;
import io.helidon.data.codegen.parser.MethodNameParserException;
import io.helidon.data.codegen.parser.MethodParserError;
import io.helidon.data.codegen.parser.ParserException;
import io.helidon.data.codegen.query.Criteria;
import io.helidon.data.codegen.query.CriteriaCondition;
import io.helidon.data.codegen.query.CriteriaOperator;
import io.helidon.data.codegen.query.DataQuery;
import io.helidon.data.codegen.query.Order;
import io.helidon.data.codegen.query.OrderExpression;
import io.helidon.data.codegen.query.OrderOperator;
import io.helidon.data.codegen.query.Projection;
import io.helidon.data.codegen.query.ProjectionAction;
import io.helidon.data.codegen.query.ProjectionExpression;
import io.helidon.data.codegen.query.ProjectionResult;
import io.helidon.data.codegen.query.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;

class MethodNameParserImpl
implements MethodNameParser {
    private static final Set<Integer> FINAL_TOKENS = Set.of(1, 2, 3, 4, 5, 6, 8, 9, 10, 17, 18, 23, 24, 67, 26, 48, 27, 49, 28, 50, 29, 51, 30, 52, 31, 53, 32, 54, 33, 55, 34, 56, 35, 57, 36, 58, 37, 59, 38, 60, 39, 61, 40, 62, 41, 63, 42, 64, 43, 65, 44, 70, 71, 73, 74);
    private final MethodName lexer = new MethodName(null);
    private final ErrorListener errorListener;
    private String methodName;
    private List<? extends Token> lexerTokens;

    private MethodNameParserImpl() {
        this.lexer.removeErrorListeners();
        this.errorListener = new ErrorListener();
        this.lexer.addErrorListener(this.errorListener);
        this.methodName = null;
        this.lexerTokens = null;
    }

    static MethodNameParserImpl create() {
        return new MethodNameParserImpl();
    }

    @Override
    public boolean parse(String methodName) {
        Objects.requireNonNull(methodName, "Name of the method is null");
        this.methodName = methodName;
        this.lexer.reset((CharStream)CharStreams.fromString((String)methodName));
        this.errorListener.reset();
        this.lexerTokens = this.lexer.getAllTokens();
        if (this.lexerTokens.isEmpty()) {
            return false;
        }
        Token lastToken = this.lexerTokens.getLast();
        return FINAL_TOKENS.contains(lastToken.getType()) && this.errorListener.isEmpty();
    }

    @Override
    public DataQuery dataQuery() {
        DataQuery.Builder queryBuilder = DataQuery.builder();
        StringBuilder identifier = new StringBuilder(32);
        Property.Builder propertyBuilder = Property.builder();
        Projection.Builder projectionBuilder = Projection.builder();
        CriteriaCondition.Builder criteriaExpressionBuilder = CriteriaCondition.builder();
        Criteria.Builder criteriaBuilder = Criteria.builder();
        OrderExpression.Builder orderExpressionBuilder = OrderExpression.builder();
        Order.Builder orderBuilder = Order.builder();
        block82: for (Token token : this.lexerTokens) {
            switch (token.getType()) {
                case 1: {
                    ((Projection.Builder)((Projection.Builder)projectionBuilder.action(ProjectionAction.Select)).result(ProjectionResult.Exists)).expression(ProjectionExpression.createExists());
                    continue block82;
                }
                case 2: {
                    ((Projection.Builder)((Projection.Builder)projectionBuilder.action(ProjectionAction.Select)).result(ProjectionResult.Count)).expression(ProjectionExpression.createCount());
                    continue block82;
                }
                case 3: {
                    ((Projection.Builder)projectionBuilder.action(ProjectionAction.Select)).result(ProjectionResult.Get);
                    continue block82;
                }
                case 4: {
                    ((Projection.Builder)projectionBuilder.action(ProjectionAction.Select)).result(ProjectionResult.Find);
                    continue block82;
                }
                case 5: {
                    ((Projection.Builder)projectionBuilder.action(ProjectionAction.Select)).result(ProjectionResult.List);
                    continue block82;
                }
                case 6: {
                    ((Projection.Builder)projectionBuilder.action(ProjectionAction.Select)).result(ProjectionResult.Stream);
                    continue block82;
                }
                case 7: {
                    throw new UnsupportedOperationException("Update statement is not supported");
                }
                case 8: {
                    ((Projection.Builder)projectionBuilder.action(ProjectionAction.Delete)).result(ProjectionResult.Dml);
                    continue block82;
                }
                case 9: {
                    String tokenString = token.getText();
                    try {
                        projectionBuilder.expression(ProjectionExpression.createFirst((int)Integer.parseInt(tokenString.substring(5))));
                        continue block82;
                    }
                    catch (NumberFormatException ex) {
                        throw new MethodNameParserException("Error parsing First<count> token", (Throwable)ex, this.methodName, tokenString);
                    }
                }
                case 10: {
                    projectionBuilder.distinct(true);
                    continue block82;
                }
                case 11: {
                    this.validateProjectionOperatorReturnType(projectionBuilder.result(), token.getText(), "Max");
                    projectionBuilder.expression(ProjectionExpression.createMax());
                    continue block82;
                }
                case 12: {
                    this.validateProjectionOperatorReturnType(projectionBuilder.result(), token.getText(), "Min");
                    projectionBuilder.expression(ProjectionExpression.createMin());
                    continue block82;
                }
                case 13: {
                    this.validateProjectionOperatorReturnType(projectionBuilder.result(), token.getText(), "Sum");
                    projectionBuilder.expression(ProjectionExpression.createSum());
                    continue block82;
                }
                case 14: {
                    this.validateProjectionOperatorReturnType(projectionBuilder.result(), token.getText(), "Avg");
                    projectionBuilder.expression(ProjectionExpression.createAvg());
                    continue block82;
                }
                case 17: {
                    identifier.setLength(0);
                    identifier.append(token.getText().toLowerCase());
                    continue block82;
                }
                case 18: {
                    identifier.append(token.getText());
                    continue block82;
                }
                case 19: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                    continue block82;
                }
                case 15: 
                case 20: {
                    if (!identifier.isEmpty()) {
                        propertyBuilder.addNamePart((CharSequence)identifier.toString());
                    }
                    if (!propertyBuilder.nameParts().isEmpty()) {
                        projectionBuilder.property(propertyBuilder.build());
                    }
                    queryBuilder.projection(projectionBuilder.build());
                    propertyBuilder = Property.builder();
                    continue block82;
                }
                case 23: {
                    identifier.setLength(0);
                    identifier.append(token.getText().toLowerCase());
                    continue block82;
                }
                case 24: {
                    identifier.append(token.getText());
                    continue block82;
                }
                case 25: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                    continue block82;
                }
                case 26: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 67: {
                    criteriaExpressionBuilder.not(true);
                    continue block82;
                }
                case 27: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 48: {
                    criteriaExpressionBuilder.ignoreCase(true);
                    continue block82;
                }
                case 28: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 49: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.After);
                    continue block82;
                }
                case 29: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 50: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.Before);
                    continue block82;
                }
                case 30: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 51: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.Contains);
                    continue block82;
                }
                case 31: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 52: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.EndsWith);
                    continue block82;
                }
                case 32: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 53: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.StartsWith);
                    continue block82;
                }
                case 33: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 54: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.Equal);
                    continue block82;
                }
                case 34: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 55: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.LessThan);
                    continue block82;
                }
                case 35: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 56: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.LessThanEqual);
                    continue block82;
                }
                case 36: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 57: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.GreaterThan);
                    continue block82;
                }
                case 37: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 58: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.GreaterThanEqual);
                    continue block82;
                }
                case 38: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 59: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.Between);
                    continue block82;
                }
                case 39: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 60: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.Like);
                    continue block82;
                }
                case 40: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 61: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.In);
                    continue block82;
                }
                case 41: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 62: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.Empty);
                    continue block82;
                }
                case 42: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 63: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.Null);
                    continue block82;
                }
                case 43: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 64: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.True);
                    continue block82;
                }
                case 44: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 65: {
                    criteriaExpressionBuilder.operator(CriteriaOperator.False);
                    continue block82;
                }
                case 45: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 68: {
                    criteriaExpressionBuilder.property(propertyBuilder.build());
                    criteriaBuilder.condition(criteriaExpressionBuilder.build());
                    criteriaBuilder.and();
                    propertyBuilder = Property.builder();
                    criteriaExpressionBuilder = CriteriaCondition.builder();
                    continue block82;
                }
                case 46: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 69: {
                    criteriaExpressionBuilder.property(propertyBuilder.build());
                    criteriaBuilder.condition(criteriaExpressionBuilder.build());
                    criteriaBuilder.or();
                    propertyBuilder = Property.builder();
                    criteriaExpressionBuilder = CriteriaCondition.builder();
                    continue block82;
                }
                case 47: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                }
                case 66: {
                    if (!propertyBuilder.nameParts().isEmpty()) {
                        criteriaExpressionBuilder.property(propertyBuilder.build());
                    }
                    criteriaBuilder.condition(criteriaExpressionBuilder.build());
                    queryBuilder.criteria(criteriaBuilder.build());
                    propertyBuilder = Property.builder();
                    continue block82;
                }
                case 70: {
                    identifier.setLength(0);
                    identifier.append(token.getText().toLowerCase());
                    continue block82;
                }
                case 71: {
                    identifier.append(token.getText());
                    continue block82;
                }
                case 72: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                    continue block82;
                }
                case 73: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                    orderBuilder.addExpression(((OrderExpression.Builder)((OrderExpression.Builder)orderExpressionBuilder.property(propertyBuilder.build())).operator(OrderOperator.ASC)).build());
                    propertyBuilder = Property.builder();
                    orderExpressionBuilder = OrderExpression.builder();
                    continue block82;
                }
                case 74: {
                    propertyBuilder.addNamePart((CharSequence)identifier.toString());
                    orderBuilder.addExpression(((OrderExpression.Builder)((OrderExpression.Builder)orderExpressionBuilder.property(propertyBuilder.build())).operator(OrderOperator.DESC)).build());
                    propertyBuilder = Property.builder();
                    orderExpressionBuilder = OrderExpression.builder();
                    continue block82;
                }
            }
            String literalName = MethodName.VOCABULARY.getLiteralName(token.getType());
            if (literalName != null) {
                throw new ParserException(String.format("Unknown parser token %s", literalName), this.methodName);
            }
            throw new ParserException(String.format("Unknown parser token type %d", token.getType()), this.methodName);
        }
        switch (this.lexerTokens.getLast().getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                queryBuilder.projection(projectionBuilder.build());
                break;
            }
            case 17: 
            case 18: {
                propertyBuilder.addNamePart((CharSequence)identifier.toString());
                queryBuilder.projection(((Projection.Builder)projectionBuilder.property(propertyBuilder.build())).build());
                break;
            }
            case 23: 
            case 24: {
                propertyBuilder.addNamePart((CharSequence)identifier.toString());
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: {
                criteriaExpressionBuilder.property(propertyBuilder.build());
                criteriaBuilder.condition(criteriaExpressionBuilder.build());
                queryBuilder.criteria(criteriaBuilder.build());
                break;
            }
            case 70: 
            case 71: {
                propertyBuilder.addNamePart((CharSequence)identifier.toString());
                orderBuilder.addExpression(((OrderExpression.Builder)orderExpressionBuilder.property(propertyBuilder.build())).build());
            }
            case 73: 
            case 74: {
                queryBuilder.order(orderBuilder.build());
                break;
            }
        }
        return queryBuilder.build();
    }

    @Override
    public List<MethodParserError> errors() {
        return List.of();
    }

    private void validateProjectionOperatorReturnType(Optional<ProjectionResult> resultType, String token, String operator) {
        resultType.ifPresentOrElse(result -> {
            switch (result) {
                case Exists: 
                case Count: 
                case Find: 
                case List: 
                case Stream: {
                    throw new MethodNameParserException("Invalid return type " + String.valueOf(result) + " for projection operator " + operator, this.methodName, token);
                }
            }
        }, () -> {
            throw new MethodNameParserException("Error parsing Max token: missing return type limitation", this.methodName, token);
        });
    }

    private static final class ErrorListener
    extends BaseErrorListener
    implements ANTLRErrorListener {
        private final List<MethodParserError> errors = new ArrayList<MethodParserError>();

        private ErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.errors.add(new MethodParserError(offendingSymbol, line, charPositionInLine));
        }

        private void reset() {
            this.errors.clear();
        }

        private List<MethodParserError> errors() {
            return this.errors;
        }

        private boolean isEmpty() {
            return this.errors.isEmpty();
        }
    }
}

