/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.common;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.codegen.spi.CodegenExtensionProvider;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.types.TypeName;
import io.helidon.data.codegen.common.RepositoryCodegen;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.common.spi.PersistenceGeneratorProvider;
import io.helidon.data.codegen.common.spi.RepositoryGenerator;
import io.helidon.data.codegen.common.spi.RepositoryGeneratorProvider;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

public class RepositoryCodegenProvider
implements CodegenExtensionProvider {
    static final List<RepositoryGenerator> DATA_REPOSITORY_GENERATORS;
    static final List<PersistenceGenerator> PERSISTENCE_GENERATORS;
    static final Set<TypeName> SUPPORTED_ANNOTATIONS;

    public CodegenExtension create(CodegenContext ctx, TypeName typeName) {
        return new RepositoryCodegen(ctx, DATA_REPOSITORY_GENERATORS, PERSISTENCE_GENERATORS);
    }

    public Set<TypeName> supportedAnnotations() {
        return SUPPORTED_ANNOTATIONS;
    }

    static {
        List repositoryGeneratorProviders = HelidonServiceLoader.create(ServiceLoader.load(RepositoryGeneratorProvider.class, RepositoryCodegen.class.getClassLoader())).asList();
        List persistenceGeneratorProviders = HelidonServiceLoader.create(ServiceLoader.load(PersistenceGeneratorProvider.class, RepositoryCodegen.class.getClassLoader())).asList();
        DATA_REPOSITORY_GENERATORS = repositoryGeneratorProviders.stream().map(RepositoryGeneratorProvider::create).collect(Collectors.toUnmodifiableList());
        PERSISTENCE_GENERATORS = persistenceGeneratorProviders.stream().map(PersistenceGeneratorProvider::create).collect(Collectors.toUnmodifiableList());
        HashSet supportedAnnotations = new HashSet();
        DATA_REPOSITORY_GENERATORS.forEach(generator -> supportedAnnotations.addAll(generator.annotations()));
        SUPPORTED_ANNOTATIONS = Set.copyOf(supportedAnnotations);
    }
}

