/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.common;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.data.codegen.common.BaseGenerator;
import io.helidon.data.codegen.common.DataCommonCodegenTypes;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.common.spi.RepositoryGenerator;
import java.util.Objects;

public abstract class BasePersistenceGenerator
extends BaseGenerator
implements PersistenceGenerator {
    protected BasePersistenceGenerator() {
    }

    @Override
    public void generate(CodegenContext codegenContext, RoundContext roundContext, TypeInfo interfaceInfo, RepositoryGenerator repositoryGenerator) {
        Objects.requireNonNull(interfaceInfo, "Data repository interface info value is null");
        Objects.requireNonNull(codegenContext, "Codegen context value is null");
        Objects.requireNonNull(repositoryGenerator, "Data repository generator value is null");
        TypeName repositoryClassName = this.repositoryClassName(interfaceInfo.typeName());
        RepositoryInfo repositoryInfo = repositoryGenerator.createRepositoryInfo(interfaceInfo, codegenContext);
        boolean should = interfaceInfo.findAnnotation(DataCommonCodegenTypes.PROVIDER).flatMap(Annotation::value).orElse(this.provider()).equals(this.provider());
        if (should) {
            ClassModel.Builder classModel = ClassModel.builder();
            this.generateRepositoryClass(codegenContext, roundContext, repositoryGenerator, repositoryInfo, repositoryClassName, classModel);
            roundContext.addGeneratedType(repositoryClassName, classModel, repositoryInfo.interfaceInfo().typeName(), new Object[]{repositoryInfo.interfaceInfo().originatingElementValue()});
        }
    }

    protected abstract String provider();

    protected abstract TypeName repositoryClassName(TypeName var1);

    protected abstract void generateRepositoryClass(CodegenContext var1, RoundContext var2, RepositoryGenerator var3, RepositoryInfo var4, TypeName var5, ClassModel.Builder var6);
}

