/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.common;

import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Consumer;

public abstract class BaseGenerator {
    protected static final String GENERIC_T = "T";
    protected static final TypeName T = TypeName.create((String)"T");
    protected static final String ENTITY = "entity";
    protected static final String ENTITIES = "entities";
    protected static final TypeName ITERABLE_T = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Iterable.class)).addTypeArgument(T)).build();
    protected static final TypeName OBJECT = TypeName.create(Object.class);
    protected static final Parameter ITERABLE_T_ENTITIES = ((Parameter.Builder)Parameter.builder().name("entities")).type(ITERABLE_T).build();
    protected static final TypeName LIST_T = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(List.class)).addTypeArgument(T)).build();
    protected static final Parameter LIST_T_ENTITIES = ((Parameter.Builder)Parameter.builder().name("entities")).type(LIST_T).build();
    protected static final Parameter T_ENTITY = ((Parameter.Builder)Parameter.builder().name("entity")).type(T).build();
    protected static final String GENERIC_WILDCARD = "?";
    protected static final String EXECUTOR = "executor";
    protected static final String ID = "id";
    protected static final TypeName NUMBER = TypeName.create(Number.class);
    protected static final TypeName BIG_INTEGER = TypeName.create(BigInteger.class);
    protected static final TypeName BIG_DECIMAL = TypeName.create(BigDecimal.class);
    protected static final TypeName CLASS_WILDCARD = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Class.class)).addTypeArgument(TypeNames.WILDCARD)).build();

    protected BaseGenerator() {
    }

    protected static void statement(Method.Builder builder, Consumer<Method.Builder> content) {
        content.accept(builder);
        builder.addContentLine(";");
    }

    protected static void returnStatement(Method.Builder builder, Consumer<Method.Builder> content) {
        builder.addContent("return ");
        content.accept(builder);
        builder.addContentLine(";");
    }

    protected static void identifier(Method.Builder builder, String identifier) {
        builder.addContent(identifier);
    }

    protected static void value(Method.Builder builder, String value) {
        builder.addContent(value);
    }

    protected static void initializedVariable(Method.Builder builder, TypeName type, String name, Consumer<Method.Builder> value) {
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(type)).addContent(" ")).addContent(name)).addContent(" = ");
        value.accept(builder);
    }

    protected static void nullValue(Method.Builder builder) {
        builder.addContent("null");
    }

    protected static void throwException(Method.Builder builder, TypeName type, String message) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("throw new ")).addContent(type)).addContent("(\"")).addContent(message)).addContent("\")");
    }

    protected static void throwException(Method.Builder builder, TypeName type, Consumer<Method.Builder> message) {
        ((Method.Builder)((Method.Builder)builder.addContent("throw new ")).addContent(type)).addContent("(");
        message.accept(builder);
        builder.addContent(")");
    }

    protected static void increasePadding(Method.Builder builder, int count) {
        for (int i = 0; i < count; ++i) {
            builder.increaseContentPadding();
        }
    }

    protected static void decreasePadding(Method.Builder builder, int count) {
        for (int i = 0; i < count; ++i) {
            builder.decreaseContentPadding();
        }
    }
}

