/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.common;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.data.codegen.common.BaseRepositoryInterfaceGenerator;
import io.helidon.data.codegen.common.DataCommonCodegenTypes;
import io.helidon.data.codegen.common.MethodParams;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import java.util.List;
import java.util.stream.Stream;

public abstract class BaseRepositoryMethodsGenerator
extends BaseRepositoryInterfaceGenerator {
    private static final TypeName STREAM = TypeName.create(Stream.class);

    protected BaseRepositoryMethodsGenerator(RepositoryInfo repositoryInfo, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        super(repositoryInfo, classModel, codegenContext, persistenceGenerator);
    }

    protected static TypeName genericReturnTypeArgument(TypedElementInfo methodInfo) {
        List genericArguments = methodInfo.typeName().typeArguments();
        if (genericArguments == null || genericArguments.isEmpty()) {
            throw new CodegenException("Missing generic argument of method " + methodInfo.elementName() + " with return type " + String.valueOf(methodInfo.typeName()));
        }
        return (TypeName)genericArguments.getFirst();
    }

    protected static boolean isListOrCollection(TypeName typeName) {
        return typeName.isList() || TypeNames.COLLECTION.equals((Object)typeName);
    }

    protected static boolean isStream(TypeName typeName) {
        return STREAM.equals((Object)typeName);
    }

    protected static boolean isSlice(TypeName typeName) {
        return DataCommonCodegenTypes.SLICE.equals((Object)typeName);
    }

    protected static boolean isPage(TypeName typeName) {
        return DataCommonCodegenTypes.PAGE.equals((Object)typeName);
    }

    protected static boolean isSliceOrPage(TypeName typeName) {
        return DataCommonCodegenTypes.SLICE.equals((Object)typeName) || DataCommonCodegenTypes.PAGE.equals((Object)typeName);
    }

    protected static String paramElementName(TypedElementInfo param) {
        return param.elementName();
    }

    protected MethodParams generateHeader(Method.Builder builder, TypedElementInfo methodInfo) {
        MethodParams methodParams = this.buildMethodParams(methodInfo.parameterArguments());
        ((Method.Builder)builder.name(methodInfo.elementName())).returnType(methodInfo.typeName()).addAnnotation(Annotation.create(Override.class));
        methodInfo.parameterArguments().forEach(parameterInfo -> builder.addParameter(((Parameter.Builder)Parameter.builder().name(parameterInfo.elementName())).type(parameterInfo.typeName()).build()));
        return methodParams;
    }

    protected abstract void processParam(MethodParams.Builder var1, TypedElementInfo var2);

    private static boolean filterParameters(TypedElementInfo info) {
        return info.kind() == ElementKind.PARAMETER;
    }

    private MethodParams buildMethodParams(List<TypedElementInfo> methodParams) {
        MethodParams.Builder builder = MethodParams.builder();
        methodParams.stream().filter(BaseRepositoryMethodsGenerator::filterParameters).forEach(typedElementInfo -> this.processParam(builder, (TypedElementInfo)typedElementInfo));
        return builder.build();
    }
}

