/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.RoundContext;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.codegen.ConfigMetadataTypes;
import io.helidon.config.metadata.codegen.ConfiguredAnnotation;
import io.helidon.config.metadata.codegen.ConfiguredOptionData;
import io.helidon.config.metadata.codegen.ConfiguredType;
import io.helidon.config.metadata.codegen.OptionType;
import io.helidon.config.metadata.codegen.TypeHandler;
import io.helidon.config.metadata.codegen.TypeHandlerBase;
import io.helidon.config.metadata.codegen.TypeHandlerResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;

class TypeHandlerMetaApi
extends TypeHandlerBase
implements TypeHandler {
    private final TypeInfo typeInfo;
    private final TypeName typeName;

    TypeHandlerMetaApi(CodegenContext ctx, TypeInfo typeInfo) {
        super(ctx);
        this.typeInfo = typeInfo;
        this.typeName = typeInfo.typeName();
    }

    public static TypeHandler create(CodegenContext ctx, TypeInfo typeInfo) {
        return new TypeHandlerMetaApi(ctx, typeInfo);
    }

    @Override
    public TypeHandlerResult handle(RoundContext roundContext) {
        String module;
        boolean isBuilder;
        TypeInfo targetType;
        Optional<TypeName> foundTarget = this.findBuilderTarget(new HashSet<TypeName>(), this.typeInfo);
        ConfiguredAnnotation configured = ConfiguredAnnotation.createMeta(this.typeInfo.annotation(ConfigMetadataTypes.META_CONFIGURED));
        if (!configured.ignoreBuildMethod() && foundTarget.isPresent()) {
            TypeName targetTypeName = foundTarget.get();
            targetType = (TypeInfo)this.ctx().typeInfo(targetTypeName, ElementInfoPredicates::isMethod).orElseThrow(() -> new IllegalStateException("Cannot find target type info for type " + targetTypeName.fqName() + ", discovered for type: " + this.typeInfo.typeName().fqName()));
            isBuilder = true;
            module = targetType.module().orElse("unknown");
        } else {
            targetType = this.typeInfo;
            isBuilder = false;
            module = this.typeInfo.module().orElse("unknown");
        }
        ConfiguredType type = new ConfiguredType(configured, this.typeName, targetType.typeName(), false);
        this.addSuperClasses(type, this.typeInfo, ConfigMetadataTypes.META_CONFIGURED);
        this.addInterfaces(type, this.typeInfo, ConfigMetadataTypes.META_CONFIGURED);
        if (isBuilder) {
            this.processBuilderType(roundContext, this.typeInfo, type, this.typeName, targetType);
        } else {
            this.processTargetType(roundContext, this.typeInfo, type, this.typeName, type.standalone());
        }
        return new TypeHandlerResult(targetType.typeName(), module, type);
    }

    List<ConfiguredOptionData> findConfiguredOptionAnnotations(RoundContext roundContext, TypedElementInfo elementInfo) {
        if (elementInfo.hasAnnotation(ConfigMetadataTypes.META_OPTIONS)) {
            Annotation metaOptions = elementInfo.annotation(ConfigMetadataTypes.META_OPTIONS);
            return metaOptions.annotationValues().stream().flatMap(Collection::stream).map(it -> ConfiguredOptionData.createMeta(this.ctx(), roundContext, it)).toList();
        }
        if (elementInfo.hasAnnotation(ConfigMetadataTypes.META_OPTION)) {
            Annotation metaOption = elementInfo.annotation(ConfigMetadataTypes.META_OPTION);
            return List.of(ConfiguredOptionData.createMeta(this.ctx(), roundContext, metaOption));
        }
        return List.of();
    }

    void processBuilderMethod(RoundContext roundContext, TypeName typeName, ConfiguredType configuredType, TypedElementInfo elementInfo, BiFunction<TypedElementInfo, ConfiguredOptionData, OptionType> optionTypeMethod, BiFunction<TypedElementInfo, OptionType, List<TypeName>> builderParamsMethod) {
        List<ConfiguredOptionData> options = this.findConfiguredOptionAnnotations(roundContext, elementInfo);
        if (options.isEmpty()) {
            return;
        }
        for (ConfiguredOptionData data : options) {
            if (!data.configured()) continue;
            String name = this.key(elementInfo, data);
            String description = this.description(roundContext, this.typeInfo, elementInfo, data);
            String defaultValue = this.defaultValue(data.defaultValue());
            boolean experimental = data.experimental();
            OptionType type = optionTypeMethod.apply(elementInfo, data);
            boolean optional = defaultValue != null || data.optional();
            boolean deprecated = data.deprecated();
            List<ConfiguredOptionData.AllowedValue> allowedValues = this.allowedValues(roundContext, data, type.elementType());
            List<TypeName> paramTypes = builderParamsMethod.apply(elementInfo, type);
            ConfiguredType.ProducerMethod builderMethod = new ConfiguredType.ProducerMethod(false, typeName, elementInfo.elementName(), paramTypes);
            ConfiguredType.ConfiguredProperty property = new ConfiguredType.ConfiguredProperty(builderMethod.toString(), name, description, defaultValue, type.elementType(), experimental, optional, type.kind(), data.provider(), data.providerType(), deprecated, data.merge(), allowedValues);
            configuredType.addProperty(property);
        }
    }

    private void processTargetType(RoundContext roundContext, TypeInfo typeInfo, ConfiguredType type, TypeName typeName, boolean standalone) {
        List<TypedElementInfo> methods = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(ElementInfoPredicates::isStatic).toList();
        boolean isTargetType = false;
        LinkedList<TypedElementInfo> validMethods = new LinkedList<TypedElementInfo>();
        TypedElementInfo configCreator = null;
        for (TypedElementInfo method : methods) {
            String name = method.elementName();
            if ("create".equals(name)) {
                TypeName paramType;
                if (!method.typeName().genericTypeName().equals((Object)typeName.genericTypeName())) continue;
                validMethods.add(method);
                List parameters = method.parameterArguments();
                if (parameters.size() == 1 && (paramType = ((TypedElementInfo)parameters.getFirst()).typeName()).equals((Object)ConfigMetadataTypes.CONFIG)) {
                    configCreator = method;
                }
                isTargetType = true;
                continue;
            }
            if (!name.equals("builder")) continue;
            throw new CodegenException("Type " + typeName.fqName() + " is marked with @Configured, yet it has a static builder() method. Please mark the builder instead of this class.", typeInfo.originatingElementValue());
        }
        if (isTargetType) {
            if (configCreator != null) {
                type.addProducer(new ConfiguredType.ProducerMethod(true, typeName, configCreator.elementName(), this.params(configCreator)));
            }
            for (TypedElementInfo validMethod : validMethods) {
                List<ConfiguredOptionData> options = this.findConfiguredOptionAnnotations(roundContext, validMethod);
                if (options.isEmpty()) continue;
                for (ConfiguredOptionData data : options) {
                    if ((data.name() == null || data.name().isBlank()) && !data.merge()) {
                        throw new CodegenException("ConfiguredOption on " + typeName.fqName() + "." + String.valueOf(validMethod) + " does not have value defined. It is mandatory on non-builder methods", typeInfo.originatingElementValue());
                    }
                    if (data.description() == null || data.description().isBlank()) {
                        throw new CodegenException("ConfiguredOption on " + typeName.fqName() + "." + String.valueOf(validMethod) + " does not have description defined. It is mandatory on non-builder methods", typeInfo.originatingElementValue());
                    }
                    if (data.type() == null) {
                        data.type(TypeNames.STRING);
                    }
                    ConfiguredType.ConfiguredProperty prop = new ConfiguredType.ConfiguredProperty(null, data.name(), data.description(), data.defaultValue(), data.type(), data.experimental(), data.optional(), data.kind(), data.provider(), data.providerType(), data.deprecated(), data.merge(), data.allowedValues());
                    type.addProperty(prop);
                }
            }
        } else {
            if (standalone) {
                throw new CodegenException("Type " + typeName.fqName() + " is marked as standalone configuration unit, yet it does have neither a builder method, nor a create method", typeInfo.originatingElementValue());
            }
            typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(TypeHandlerMetaApi.isMine(typeName)).forEach(it -> this.processBuilderMethod(roundContext, typeName, type, (TypedElementInfo)it));
        }
    }

    private void processBuilderType(RoundContext roundContext, TypeInfo typeInfo, ConfiguredType type, TypeName typeName, TypeInfo targetType) {
        type.addProducer(new ConfiguredType.ProducerMethod(false, typeName, "build", List.of()));
        TypeName targetTypeName = targetType.typeName();
        if (targetType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(ElementInfoPredicates.elementName((String)"create")).filter(TypeHandlerBase::hasConfigParam).anyMatch(TypeHandlerMetaApi.isMine(targetTypeName))) {
            type.addProducer(new ConfiguredType.ProducerMethod(true, targetTypeName, "create", List.of(ConfigMetadataTypes.CONFIG)));
        }
        typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(TypeHandlerMetaApi.isMine(typeName)).filter(it -> it.hasAnnotation(ConfigMetadataTypes.META_OPTION) || it.hasAnnotation(ConfigMetadataTypes.META_OPTIONS)).forEach(it -> this.processBuilderMethod(roundContext, typeName, type, (TypedElementInfo)it));
    }

    private List<TypeName> builderMethodParams(TypedElementInfo elementInfo, OptionType type) {
        return this.params(elementInfo);
    }

    private void processBuilderMethod(RoundContext roundContext, TypeName typeName, ConfiguredType configuredType, TypedElementInfo elementInfo) {
        this.processBuilderMethod(roundContext, typeName, configuredType, elementInfo, this::optionType, this::builderMethodParams);
    }

    private OptionType optionType(TypedElementInfo elementInfo, ConfiguredOptionData annotation) {
        if (annotation.type() == null || annotation.type().equals((Object)ConfigMetadataTypes.META_OPTION)) {
            List parameters = elementInfo.parameterArguments();
            if (parameters.size() != 1) {
                throw new CodegenException("Method " + elementInfo.elementName() + " is annotated with @ConfiguredOption, yet it does not have explicit type, or exactly one parameter", this.typeInfo.originatingElementValue());
            }
            TypedElementInfo parameter = (TypedElementInfo)parameters.getFirst();
            TypeName paramType = parameter.typeName();
            if (paramType.isList() || paramType.isSet()) {
                return new OptionType((TypeName)paramType.typeArguments().getFirst(), "LIST");
            }
            if (paramType.isMap()) {
                return new OptionType((TypeName)paramType.typeArguments().get(1), "MAP");
            }
            return new OptionType(paramType.boxed(), annotation.kind());
        }
        return new OptionType(annotation.type(), annotation.kind());
    }

    private Optional<TypeName> findBuilderTarget(Set<TypeName> processed, TypeInfo typeInfo) {
        return typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(ElementInfoPredicates::hasNoArgs).filter(ElementInfoPredicates.elementName((String)"build")).filter(Predicate.not(ElementInfoPredicates::isVoid)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).findFirst().map(it -> it.typeName());
    }
}

