/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.RoundContext;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.codegen.ConfigMetadataTypes;
import io.helidon.config.metadata.codegen.ConfiguredOptionData;
import io.helidon.config.metadata.codegen.ConfiguredType;
import io.helidon.config.metadata.codegen.Javadoc;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

abstract class TypeHandlerBase {
    static final String UNCONFIGURED_OPTION = "io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED";
    private final CodegenContext ctx;

    TypeHandlerBase(CodegenContext ctx) {
        this.ctx = ctx;
    }

    static Predicate<TypedElementInfo> isMine(TypeName type) {
        TypeName withoutGenerics = type.genericTypeName();
        return info -> info.enclosingType().map(TypeName::genericTypeName).map(arg_0 -> ((TypeName)withoutGenerics).equals(arg_0)).orElse(true);
    }

    static boolean hasConfigParam(TypedElementInfo info) {
        List arguments = info.parameterArguments();
        if (arguments.size() != 1) {
            return false;
        }
        TypeName argumentType = ((TypedElementInfo)arguments.getFirst()).typeName();
        return ConfigMetadataTypes.CONFIG.equals((Object)argumentType);
    }

    static String toConfigKey(String methodName) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        for (char aChar : chars = methodName.toCharArray()) {
            if (Character.isUpperCase(aChar)) {
                if (result.isEmpty()) {
                    result.append(Character.toLowerCase(aChar));
                    continue;
                }
                result.append('-').append(Character.toLowerCase(aChar));
                continue;
            }
            result.append(aChar);
        }
        return result.toString();
    }

    String javadoc(RoundContext roundContext, TypeInfo currentType, String docComment) {
        return Javadoc.parse(roundContext, currentType, docComment);
    }

    String key(TypedElementInfo elementInfo, ConfiguredOptionData configuredOption) {
        String name = configuredOption.name();
        if (name == null || name.isBlank()) {
            return TypeHandlerBase.toConfigKey(elementInfo.elementName());
        }
        return name;
    }

    String description(RoundContext roundContext, TypeInfo typeInfo, TypedElementInfo elementInfo, ConfiguredOptionData configuredOption) {
        String desc = configuredOption.description();
        if (desc == null) {
            return this.javadoc(roundContext, typeInfo, elementInfo.description().orElse(null));
        }
        return desc;
    }

    String defaultValue(String defaultValue) {
        return UNCONFIGURED_OPTION.equals(defaultValue) ? null : defaultValue;
    }

    List<ConfiguredOptionData.AllowedValue> allowedValues(RoundContext roundContext, ConfiguredOptionData configuredOption, TypeName type) {
        if (type.equals((Object)configuredOption.type()) || !configuredOption.allowedValues().isEmpty()) {
            return configuredOption.allowedValues();
        }
        return this.allowedValues(roundContext, type);
    }

    CodegenContext ctx() {
        return this.ctx;
    }

    List<TypeName> params(TypedElementInfo info) {
        return info.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).typeName()).toList();
    }

    void addInterfaces(ConfiguredType type, TypeInfo typeInfo, TypeName requiredAnnotation) {
        for (TypeInfo interfaceInfo : typeInfo.interfaceTypeInfo()) {
            if (interfaceInfo.hasAnnotation(requiredAnnotation)) {
                type.addInherited(interfaceInfo.typeName());
                continue;
            }
            this.addSuperClasses(type, interfaceInfo, requiredAnnotation);
        }
    }

    void addSuperClasses(ConfiguredType type, TypeInfo typeInfo, TypeName requiredAnnotation) {
        Optional foundSuperType = typeInfo.superTypeInfo();
        if (foundSuperType.isEmpty()) {
            return;
        }
        TypeInfo superClass = (TypeInfo)foundSuperType.get();
        while (true) {
            if (superClass.hasAnnotation(requiredAnnotation)) {
                type.addInherited(superClass.typeName());
                return;
            }
            foundSuperType = superClass.superTypeInfo();
            if (foundSuperType.isEmpty()) {
                return;
            }
            superClass = (TypeInfo)foundSuperType.get();
        }
    }

    List<ConfiguredOptionData.AllowedValue> allowedValuesEnum(RoundContext roundContext, ConfiguredOptionData data, TypeInfo enumInfo) {
        if (!data.allowedValues().isEmpty()) {
            return data.allowedValues();
        }
        return this.allowedValuesEnum(roundContext, enumInfo);
    }

    private List<ConfiguredOptionData.AllowedValue> allowedValuesEnum(RoundContext roundContext, TypeInfo enumInfo) {
        ArrayList<ConfiguredOptionData.AllowedValue> values = new ArrayList<ConfiguredOptionData.AllowedValue>();
        ConfiguredOptionData.enumAllowedValues(roundContext, values, enumInfo);
        return values;
    }

    private List<ConfiguredOptionData.AllowedValue> allowedValues(RoundContext roundContext, TypeName type) {
        return this.ctx().typeInfo(type).filter(it -> it.kind() == ElementKind.ENUM).map(it -> this.allowedValuesEnum(roundContext, (TypeInfo)it)).orElseGet(List::of);
    }
}

