/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.codegen;

import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.RoundContext;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.Optional;
import java.util.regex.Pattern;

final class Javadoc {
    private static final Pattern JAVADOC_CODE = Pattern.compile("\\{@code (.*?)}");
    private static final Pattern JAVADOC_LINK = Pattern.compile("\\{@link (.*?)}");
    private static final Pattern JAVADOC_LINKPLAIN = Pattern.compile("\\{@linkplain (.*?)}");
    private static final Pattern JAVADOC_VALUE = Pattern.compile("\\{@value (.*?)}");
    private static final Pattern JAVADOC_SEE = Pattern.compile("@see (.*?\n)");

    private Javadoc() {
    }

    static String parse(RoundContext roundContext, TypeInfo currentType, String javadoc) {
        return Javadoc.parse(roundContext, currentType, javadoc, true);
    }

    static String parse(RoundContext roundContext, TypeInfo currentType, String docComment, boolean includeReturn) {
        if (docComment == null) {
            return "";
        }
        Object javadoc = docComment;
        int index = ((String)javadoc).indexOf("@param");
        if (index > -1) {
            javadoc = docComment.substring(0, index);
        }
        javadoc = JAVADOC_CODE.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocCode(it.group(1)));
        javadoc = JAVADOC_LINK.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocLink(it.group(1)));
        javadoc = JAVADOC_LINKPLAIN.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocLink(it.group(1)));
        javadoc = JAVADOC_VALUE.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocConstantValue(roundContext, currentType, it.group(1)));
        int count = 9;
        index = ((String)javadoc).indexOf(" @return");
        if (index == -1) {
            count = 8;
            index = ((String)javadoc).indexOf("@return");
        }
        if (index > -1) {
            if (includeReturn) {
                javadoc = ((String)javadoc).substring(0, index) + CodegenUtil.capitalize((String)((String)javadoc).substring(index + count).trim());
            } else {
                int nextAt;
                int endIndex = ((String)javadoc).length();
                int nextIndex = index + count;
                while ((nextAt = ((String)javadoc).indexOf(64, nextIndex)) != -1 && nextAt != 0 && nextAt != ((String)javadoc).length() - 1) {
                    if (((String)javadoc).charAt(nextAt - 1) == '{') {
                        nextIndex = nextAt + 1;
                        continue;
                    }
                    endIndex = nextAt;
                    break;
                }
                javadoc = ((String)javadoc).substring(0, index) + ((String)javadoc).substring(endIndex);
            }
        }
        javadoc = JAVADOC_SEE.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocSee(it.group(1)));
        return ((String)javadoc).trim();
    }

    private static String javadocSee(String originalValue) {
        return "See " + Javadoc.javadocValue(originalValue);
    }

    private static String javadocCode(String originalValue) {
        return "`" + originalValue + "`";
    }

    private static String javadocLink(String originalValue) {
        return Javadoc.javadocValue(originalValue);
    }

    private static String javadocValue(String originalValue) {
        if (originalValue.startsWith("#")) {
            return originalValue.substring(1);
        }
        int index = 0;
        StringBuilder result = new StringBuilder();
        while (true) {
            int indexOfHref;
            if ((indexOfHref = originalValue.indexOf("href=\"", index)) == -1) {
                result.append(Javadoc.removeHash(originalValue.substring(index)));
                break;
            }
            int endOfHref = originalValue.indexOf(34, indexOfHref + 6);
            if (endOfHref == -1) {
                result.append(originalValue.substring(index));
                break;
            }
            result.append(originalValue, index, endOfHref + 1);
            index = endOfHref + 1;
        }
        return result.toString();
    }

    private static String removeHash(String originalValue) {
        return originalValue.replace('#', '.');
    }

    private static String javadocConstantValue(RoundContext roundContext, TypeInfo currentType, String originalValue) {
        if (originalValue.startsWith("#")) {
            String constantName = originalValue.substring(1);
            return Javadoc.constantValue(currentType, originalValue, constantName);
        }
        int separator = originalValue.lastIndexOf(35);
        if (separator < 0) {
            return Javadoc.javadocValue(originalValue);
        }
        TypeName typeName = TypeName.create((String)originalValue.substring(0, separator));
        if (typeName.packageName().isEmpty()) {
            typeName = ((TypeName.Builder)TypeName.builder((TypeName)typeName).packageName(currentType.typeName().packageName())).build();
        }
        String constantName = originalValue.substring(separator + 1);
        Optional constantType = roundContext.typeInfo(typeName);
        if (constantType.isEmpty()) {
            return Javadoc.javadocValue(originalValue);
        }
        return Javadoc.constantValue((TypeInfo)constantType.get(), originalValue, constantName);
    }

    private static String constantValue(TypeInfo currentType, String originalValue, String constantName) {
        Optional fieldValue = currentType.elementInfo().stream().filter(ElementInfoPredicates::isField).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.elementName((String)constantName)).findFirst().flatMap(rec$ -> ((TypedElementInfo)rec$).defaultValue());
        if (fieldValue.isEmpty()) {
            return Javadoc.javadocValue(originalValue);
        }
        String constantValue = (String)fieldValue.get();
        constantValue = constantValue.replace('`', '\"');
        constantValue = constantValue.replaceAll("\\$", "\\\\\\$");
        return "`" + constantValue + "`";
    }
}

