/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.config.metadata.codegen.ConfigMetadataTypes;
import io.helidon.config.metadata.codegen.ConfiguredType;
import io.helidon.config.metadata.codegen.TypeHandlerBuilderApi;
import io.helidon.config.metadata.codegen.TypeHandlerMetaApi;
import io.helidon.metadata.hson.Hson;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

class ConfigMetadataCodegenExtension
implements CodegenExtension {
    private static final String META_FILE = "META-INF/helidon/config-metadata.json";
    private final Set<TypeName> blueprints = new HashSet<TypeName>();
    private final Set<TypeName> configMetadata = new HashSet<TypeName>();
    private final Map<TypeName, ConfiguredType> newOptions = new HashMap<TypeName, ConfiguredType>();
    private final Map<String, List<TypeName>> moduleTypes = new HashMap<String, List<TypeName>>();
    private final CodegenContext ctx;

    ConfigMetadataCodegenExtension(CodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RoundContext roundContext) {
        roundContext.annotatedTypes(ConfigMetadataTypes.CONFIGURED).forEach(it -> this.blueprints.add(it.typeName()));
        roundContext.annotatedTypes(ConfigMetadataTypes.META_CONFIGURED).forEach(it -> this.configMetadata.add(it.typeName()));
    }

    public void processingOver(RoundContext roundContext) {
        Stream.concat(this.typesToProcess(this.blueprints).map(it -> TypeHandlerBuilderApi.create(this.ctx, it)), this.typesToProcess(this.configMetadata).map(it -> TypeHandlerMetaApi.create(this.ctx, it))).map(it -> it.handle(roundContext)).forEach(it -> {
            TypeName targetType = it.targetType();
            this.newOptions.put(targetType, it.configuredType());
            this.moduleTypes.computeIfAbsent(it.moduleName(), ignored -> new ArrayList()).add(targetType);
        });
        this.storeMetadata();
    }

    private Stream<TypeInfo> typesToProcess(Set<TypeName> typeNames) {
        return typeNames.stream().map(arg_0 -> ((CodegenContext)this.ctx).typeInfo(arg_0)).flatMap(Optional::stream);
    }

    private void storeMetadata() {
        if (this.moduleTypes.isEmpty()) {
            return;
        }
        ArrayList<Hson.Struct> root = new ArrayList<Hson.Struct>();
        for (Map.Entry<String, List<TypeName>> module : this.moduleTypes.entrySet()) {
            String moduleName = module.getKey();
            List<TypeName> types = module.getValue();
            ArrayList typeArray = new ArrayList();
            types.forEach(it -> this.newOptions.get(it).write(typeArray));
            root.add((Hson.Struct)Hson.structBuilder().set("module", moduleName).setStructs("types", typeArray).build());
        }
        if (!root.isEmpty()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintWriter w = new PrintWriter(baos, true, StandardCharsets.UTF_8);){
                Hson.Array.create(root).write(w);
            }
            this.ctx.filer().writeResource(baos.toByteArray(), META_FILE, new Object[0]);
        }
    }
}

