/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.RoundContext;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.codegen.ConfigMetadataTypes;
import io.helidon.config.metadata.codegen.ConfiguredAnnotation;
import io.helidon.config.metadata.codegen.ConfiguredOptionData;
import io.helidon.config.metadata.codegen.ConfiguredType;
import io.helidon.config.metadata.codegen.Javadoc;
import io.helidon.config.metadata.codegen.OptionType;
import io.helidon.config.metadata.codegen.TypeHandler;
import io.helidon.config.metadata.codegen.TypeHandlerBase;
import io.helidon.config.metadata.codegen.TypeHandlerResult;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

class TypeHandlerBuilderApi
extends TypeHandlerBase
implements TypeHandler {
    private final TypeInfo blueprint;
    private final TypeName blueprintType;

    TypeHandlerBuilderApi(CodegenContext ctx, TypeInfo blueprint) {
        super(ctx);
        this.blueprint = blueprint;
        this.blueprintType = blueprint.typeName();
    }

    static TypeHandler create(CodegenContext ctx, TypeInfo typeInfo) {
        return new TypeHandlerBuilderApi(ctx, typeInfo);
    }

    @Override
    public TypeHandlerResult handle(RoundContext roundContext) {
        TypeName prototype = TypeHandlerBuilderApi.prototype(this.blueprintType);
        TypeName builderType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)prototype).className("Builder")).addEnclosingName(prototype.className())).build();
        TypeName targetType = TypeHandlerBuilderApi.targetType(this.blueprint, prototype);
        String module = this.blueprint.module().orElse("unknown");
        ConfiguredAnnotation configured = ConfiguredAnnotation.createBuilder(this.blueprint);
        ConfiguredType type = new ConfiguredType(configured, prototype, targetType, true);
        this.addInterfaces(type, this.blueprint, ConfigMetadataTypes.CONFIGURED);
        type.addProducer(new ConfiguredType.ProducerMethod(true, prototype, "create", List.of(ConfigMetadataTypes.CONFIG)));
        type.addProducer(new ConfiguredType.ProducerMethod(true, prototype, "builder", List.of()));
        if (!targetType.equals((Object)prototype)) {
            type.addProducer(new ConfiguredType.ProducerMethod(false, targetType, "create", List.of(prototype)));
        }
        this.blueprint.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(TypeHandlerBase.isMine(this.blueprint.typeName())).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isDefault)).filter(ElementInfoPredicates.hasAnnotation((TypeName)ConfigMetadataTypes.OPTION_CONFIGURED)).forEach(it -> this.processBlueprintMethod(roundContext, this.blueprint, builderType, type, (TypedElementInfo)it));
        return new TypeHandlerResult(targetType, module, type);
    }

    @Override
    void addInterfaces(ConfiguredType type, TypeInfo typeInfo, TypeName requiredAnnotation) {
        for (TypeInfo interfaceInfo : typeInfo.interfaceTypeInfo()) {
            if (interfaceInfo.hasAnnotation(requiredAnnotation)) {
                TypeName ifaceTypeName = interfaceInfo.typeName();
                if (interfaceInfo.hasAnnotation(ConfigMetadataTypes.BLUEPRINT)) {
                    String className = ifaceTypeName.className();
                    if (className.endsWith("Blueprint")) {
                        className = className.substring(0, className.length() - "Blueprint".length());
                    }
                    ifaceTypeName = ((TypeName.Builder)TypeName.builder((TypeName)ifaceTypeName).className(className)).build();
                }
                type.addInherited(ifaceTypeName);
                continue;
            }
            this.addSuperClasses(type, interfaceInfo, requiredAnnotation);
        }
    }

    @Override
    String javadoc(RoundContext roundContext, TypeInfo currentType, String docComment) {
        return Javadoc.parse(roundContext, currentType, docComment, false);
    }

    private static TypeName prototype(TypeName blueprintType) {
        String className = blueprintType.className();
        if (className.endsWith("Blueprint")) {
            className = className.substring(0, className.length() - "Blueprint".length());
        }
        return ((TypeName.Builder)TypeName.builder((TypeName)blueprintType).className(className)).build().genericTypeName();
    }

    private static TypeName targetType(TypeInfo blueprint, TypeName prototype) {
        return blueprint.interfaceTypeInfo().stream().map(rec$ -> ((TypeInfo)rec$).typeName()).filter(it -> ConfigMetadataTypes.PROTOTYPE_FACTORY.equals((Object)it.genericTypeName())).filter(it -> it.typeArguments().size() == 1).map(it -> (TypeName)it.typeArguments().getFirst()).findAny().orElse(prototype);
    }

    private OptionType typeForBlueprintFromSignature(TypedElementInfo element, ConfiguredOptionData annotation) {
        if (!ElementInfoPredicates.hasNoArgs((TypedElementInfo)element)) {
            throw new CodegenException("Method " + String.valueOf(element) + " is annotated with @Configured, yet it has a parameter. Interface methods must not have parameters.", element.originatingElementValue());
        }
        TypeName returnType = element.typeName();
        if (ElementInfoPredicates.isVoid((TypedElementInfo)element)) {
            throw new CodegenException("Method " + String.valueOf(element) + " is annotated with @Configured, yet it is void. Interface methods must return the property type.", element.originatingElementValue());
        }
        if (returnType.isOptional()) {
            if (!(returnType.isMap() || returnType.isSet() || returnType.isList())) {
                return new OptionType((TypeName)returnType.typeArguments().getFirst(), "VALUE");
            }
            returnType = (TypeName)returnType.typeArguments().getFirst();
        }
        if (returnType.isList() || returnType.isSet()) {
            return new OptionType((TypeName)returnType.typeArguments().getFirst(), "LIST");
        }
        if (returnType.isMap()) {
            return new OptionType((TypeName)returnType.typeArguments().get(1), "MAP");
        }
        return new OptionType(returnType.boxed(), annotation.kind());
    }

    private void processBlueprintMethod(RoundContext roundContext, TypeInfo currentType, TypeName typeName, ConfiguredType configuredType, TypedElementInfo elementInfo) {
        List<ConfiguredOptionData.AllowedValue> allowedValues;
        ConfiguredOptionData data = ConfiguredOptionData.createBuilder(elementInfo);
        String name = this.key(elementInfo, data);
        String description = this.description(roundContext, currentType, elementInfo, data);
        Object defaultValue = this.defaultValue(data.defaultValue());
        boolean experimental = data.experimental();
        OptionType type = this.typeForBlueprintFromSignature(elementInfo, data);
        boolean optional = defaultValue != null || data.optional();
        boolean deprecated = data.deprecated();
        Optional<TypeInfo> enumType = this.ctx().typeInfo(type.elementType()).filter(it -> it.kind() == ElementKind.ENUM);
        if (enumType.isPresent() && defaultValue != null) {
            defaultValue = type.elementType().className() + "." + (String)defaultValue;
            allowedValues = this.allowedValuesEnum(roundContext, data, enumType.get());
        } else {
            allowedValues = this.allowedValues(roundContext, data, type.elementType());
        }
        List<TypeName> paramTypes = List.of(elementInfo.typeName());
        ConfiguredType.ProducerMethod builderMethod = new ConfiguredType.ProducerMethod(false, typeName, elementInfo.elementName(), paramTypes);
        ConfiguredType.ConfiguredProperty property = new ConfiguredType.ConfiguredProperty(builderMethod.toString(), name, description, (String)defaultValue, type.elementType(), experimental, optional, type.kind(), data.provider(), data.providerType(), deprecated, data.merge(), allowedValues);
        configuredType.addProperty(property);
    }
}

