/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.codegen.ConfigMetadataTypes;
import io.helidon.config.metadata.codegen.Javadoc;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

final class ConfiguredOptionData {
    private final List<AllowedValue> allowedValues = new LinkedList<AllowedValue>();
    private boolean configured = true;
    private String name;
    private TypeName type;
    private String description;
    private boolean required;
    private String defaultValue;
    private boolean experimental;
    private boolean provider;
    private boolean deprecated;
    private boolean merge;
    private String kind = "VALUE";
    private TypeName providerType;

    ConfiguredOptionData() {
    }

    static ConfiguredOptionData createMeta(CodegenContext ctx, Annotation option) {
        ConfiguredOptionData result = new ConfiguredOptionData();
        option.booleanValue("configured").ifPresent(result::configured);
        option.stringValue("key").filter(Predicate.not(String::isBlank)).ifPresent(result::name);
        option.stringValue("description").filter(Predicate.not(String::isBlank)).ifPresent(result::description);
        option.stringValue().filter(Predicate.not("io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED"::equals)).ifPresent(result::defaultValue);
        option.booleanValue("experimental").ifPresent(result::experimental);
        option.booleanValue("required").ifPresent(result::required);
        option.booleanValue("mergeWithParent").ifPresent(result::merge);
        option.typeValue("type").ifPresent(result::type);
        option.stringValue("kind").ifPresent(result::kind);
        option.booleanValue("provider").ifPresent(result::provider);
        option.booleanValue("deprecated").ifPresent(result::deprecated);
        option.annotationValues("allowedValues").or(() -> option.annotationValue("allowedValue").map(List::of)).stream().flatMap(Collection::stream).map(AllowedValue::create).forEach(result::addAllowedValue);
        if (result.allowedValues.isEmpty()) {
            option.getValue("type").map(TypeName::create).flatMap(arg_0 -> ((CodegenContext)ctx).typeInfo(arg_0)).filter(it -> it.kind() == ElementKind.ENUM).ifPresent(it -> ConfiguredOptionData.enumAllowedValues(result.allowedValues(), it));
        }
        return result;
    }

    static ConfiguredOptionData createBuilder(TypedElementInfo element) {
        ConfiguredOptionData result = new ConfiguredOptionData();
        Optional optionConfigured = element.findAnnotation(ConfigMetadataTypes.OPTION_CONFIGURED);
        optionConfigured.flatMap(rec$ -> ((Annotation)rec$).stringValue()).filter(Predicate.not(String::isBlank)).ifPresent(result::name);
        optionConfigured.flatMap(it -> it.booleanValue("merge")).ifPresent(result::merge);
        element.findAnnotation(ConfigMetadataTypes.DESCRIPTION).flatMap(rec$ -> ((Annotation)rec$).stringValue()).ifPresent(result::description);
        element.findAnnotation(ConfigMetadataTypes.OPTION_REQUIRED).ifPresent(it -> result.required(true));
        element.findAnnotation(ConfigMetadataTypes.OPTION_PROVIDER).ifPresent(it -> {
            it.typeValue().ifPresent(result::providerType);
            result.provider(true);
        });
        element.findAnnotation(ConfigMetadataTypes.DEPRECATED).ifPresent(it -> result.deprecated(true));
        element.findAnnotation(ConfigMetadataTypes.OPTION_ALLOWED_VALUES).flatMap(rec$ -> ((Annotation)rec$).annotationValues()).or(() -> element.findAnnotation(ConfigMetadataTypes.OPTION_ALLOWED_VALUE).map(List::of)).stream().flatMap(Collection::stream).map(AllowedValue::create).forEach(result::addAllowedValue);
        Optional defaultValues = element.findAnnotation(ConfigMetadataTypes.OPTION_DEFAULT).or(() -> element.findAnnotation(ConfigMetadataTypes.OPTION_DEFAULT_INT)).or(() -> element.findAnnotation(ConfigMetadataTypes.OPTION_DEFAULT_BOOLEAN)).or(() -> element.findAnnotation(ConfigMetadataTypes.OPTION_DEFAULT_LONG)).or(() -> element.findAnnotation(ConfigMetadataTypes.OPTION_DEFAULT_DOUBLE));
        if (defaultValues.isPresent()) {
            List strings = ((Annotation)defaultValues.get()).stringValues().orElseGet(List::of);
            result.defaultValue(String.join((CharSequence)", ", strings));
        } else if (element.hasAnnotation(ConfigMetadataTypes.OPTION_DEFAULT_METHOD)) {
            Annotation annotation = element.annotation(ConfigMetadataTypes.OPTION_DEFAULT_METHOD);
            TypeName type = annotation.typeValue("type").filter(Predicate.not(arg_0 -> ((TypeName)ConfigMetadataTypes.OPTION_DEFAULT_METHOD).equals(arg_0))).or(() -> element.enclosingType()).orElse(null);
            String value = annotation.stringValue().orElse(null);
            if (value != null) {
                if (type == null) {
                    result.defaultValue(value + "()");
                } else {
                    result.defaultValue(type.fqName() + "." + value + "()");
                }
            }
        } else if (element.hasAnnotation(ConfigMetadataTypes.OPTION_DEFAULT_CODE)) {
            element.annotation(ConfigMetadataTypes.OPTION_DEFAULT_CODE).stringValue().ifPresent(result::defaultValue);
        }
        return result;
    }

    static void enumAllowedValues(List<AllowedValue> allowedValues, TypeInfo typeInfo) {
        typeInfo.elementInfo().stream().filter(it -> it.kind() == ElementKind.ENUM_CONSTANT).forEach(it -> allowedValues.add(new AllowedValue(it.elementName(), it.description().map(Javadoc::parse).orElse(""))));
    }

    List<AllowedValue> allowedValues() {
        return this.allowedValues;
    }

    String name() {
        return this.name;
    }

    TypeName type() {
        return this.type;
    }

    String description() {
        return this.description;
    }

    boolean optional() {
        return !this.required;
    }

    String defaultValue() {
        return this.defaultValue;
    }

    boolean experimental() {
        return this.experimental;
    }

    boolean provider() {
        return this.provider;
    }

    TypeName providerType() {
        return this.providerType;
    }

    boolean deprecated() {
        return this.deprecated;
    }

    boolean merge() {
        return this.merge;
    }

    String kind() {
        return this.kind;
    }

    boolean configured() {
        return this.configured;
    }

    void type(TypeName type) {
        this.type = type;
    }

    void name(String name) {
        this.name = name;
    }

    void description(String description) {
        this.description = description;
    }

    void required(boolean required) {
        this.required = required;
    }

    void defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void experimental(boolean experimental) {
        this.experimental = experimental;
    }

    void provider(boolean provider) {
        this.provider = provider;
    }

    void providerType(TypeName provider) {
        this.providerType = provider;
    }

    void deprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    void merge(boolean merge) {
        this.merge = merge;
    }

    void kind(String kind) {
        this.kind = kind;
    }

    void addAllowedValue(AllowedValue value) {
        this.allowedValues.add(value);
    }

    void configured(boolean configured) {
        this.configured = configured;
    }

    static final class AllowedValue {
        private String value;
        private String description;

        private AllowedValue() {
        }

        AllowedValue(String value, String description) {
            this.value = value;
            this.description = description;
        }

        String value() {
            return this.value;
        }

        String description() {
            return this.description;
        }

        private static AllowedValue create(Annotation annotation) {
            AllowedValue result = new AllowedValue();
            annotation.stringValue().ifPresent(it -> {
                result.value = it;
            });
            annotation.stringValue("description").filter(Predicate.not(String::isBlank)).ifPresent(it -> {
                result.description = it;
            });
            return result;
        }
    }
}

