/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.codegen;

import io.helidon.codegen.CodegenUtil;
import java.util.regex.Pattern;

final class Javadoc {
    private static final Pattern JAVADOC_CODE = Pattern.compile("\\{@code (.*?)}");
    private static final Pattern JAVADOC_LINK = Pattern.compile("\\{@link (.*?)}");
    private static final Pattern JAVADOC_LINKPLAIN = Pattern.compile("\\{@linkplain (.*?)}");
    private static final Pattern JAVADOC_VALUE = Pattern.compile("\\{@value (.*?)}");
    private static final Pattern JAVADOC_SEE = Pattern.compile("@see (.*?\n)");

    private Javadoc() {
    }

    static String parse(String javadoc) {
        return Javadoc.parse(javadoc, true);
    }

    static String parse(String docComment, boolean includeReturn) {
        if (docComment == null) {
            return "";
        }
        Object javadoc = docComment;
        int index = ((String)javadoc).indexOf("@param");
        if (index > -1) {
            javadoc = docComment.substring(0, index);
        }
        javadoc = JAVADOC_CODE.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocCode(it.group(1)));
        javadoc = JAVADOC_LINK.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocLink(it.group(1)));
        javadoc = JAVADOC_LINKPLAIN.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocLink(it.group(1)));
        javadoc = JAVADOC_VALUE.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocValue(it.group(1)));
        javadoc = JAVADOC_SEE.matcher((CharSequence)javadoc).replaceAll(it -> Javadoc.javadocSee(it.group(1)));
        int count = 9;
        index = ((String)javadoc).indexOf(" @return");
        if (index == -1) {
            count = 8;
            index = ((String)javadoc).indexOf("@return");
        }
        if (index > -1) {
            if (includeReturn) {
                javadoc = ((String)javadoc).substring(0, index) + CodegenUtil.capitalize((String)((String)javadoc).substring(index + count).trim());
            } else {
                int nextAt;
                int endIndex = ((String)javadoc).length();
                int nextIndex = index;
                while ((nextAt = ((String)javadoc).indexOf(64, nextIndex)) != -1 && nextAt != 0 && nextAt != ((String)javadoc).length() - 1) {
                    if (((String)javadoc).charAt(nextAt - 1) == '{') {
                        nextIndex = nextAt + 1;
                        continue;
                    }
                    endIndex = nextAt;
                    break;
                }
                javadoc = ((String)javadoc).substring(0, index) + ((String)javadoc).substring(endIndex);
            }
        }
        return ((String)javadoc).trim();
    }

    private static String javadocSee(String originalValue) {
        return "See " + Javadoc.javadocValue(originalValue);
    }

    private static String javadocCode(String originalValue) {
        return "`" + originalValue + "`";
    }

    private static String javadocLink(String originalValue) {
        return Javadoc.javadocValue(originalValue);
    }

    private static String javadocValue(String originalValue) {
        if (originalValue.startsWith("#")) {
            return originalValue.substring(1);
        }
        return originalValue.replace('#', '.');
    }
}

